/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.Token;
import org.springframework.xd.dirt.stream.dsl.TokenKind;
import org.springframework.xd.dirt.stream.dsl.XDDSLMessages;

class Tokenizer {
    private String expressionString;
    private char[] toProcess;
    private int max;
    private int pos;
    private List<Token> tokens = new ArrayList<Token>();
    private static final byte[] flags = new byte[256];
    private static final byte IS_DIGIT = 1;
    private static final byte IS_HEXDIGIT = 2;
    private static final byte IS_ALPHA = 4;

    public Tokenizer(String inputdata) {
        this.expressionString = inputdata;
        this.toProcess = (inputdata + "\u0000").toCharArray();
        this.max = this.toProcess.length;
        this.pos = 0;
        this.process();
    }

    private void process() {
        boolean justProcessedEquals = false;
        block17: while (this.pos < this.max) {
            char ch = this.toProcess[this.pos];
            if (justProcessedEquals) {
                if (!this.isWhitespace(ch) && ch != '\u0000') {
                    this.lexArgValueIdentifier();
                }
                justProcessedEquals = false;
                continue;
            }
            if (this.isAlphabetic(ch) || this.isDigit(ch) || ch == '_') {
                this.lexIdentifier();
                continue;
            }
            switch (ch) {
                case '-': {
                    if (!this.isTwoCharToken(TokenKind.DOUBLE_MINUS)) {
                        throw new StreamDefinitionException(this.expressionString, this.pos, XDDSLMessages.MISSING_CHARACTER, "-");
                    }
                    this.pushPairToken(TokenKind.DOUBLE_MINUS);
                    continue block17;
                }
                case '=': {
                    justProcessedEquals = true;
                    this.pushCharToken(TokenKind.EQUALS);
                    continue block17;
                }
                case '&': {
                    this.pushCharToken(TokenKind.AND);
                    continue block17;
                }
                case '|': {
                    this.pushCharToken(TokenKind.PIPE);
                    continue block17;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block17;
                }
                case '\n': {
                    this.pushCharToken(TokenKind.NEWLINE);
                    continue block17;
                }
                case '.': {
                    this.pushCharToken(TokenKind.DOT);
                    continue block17;
                }
                case '>': {
                    this.pushCharToken(TokenKind.GT);
                    continue block17;
                }
                case ':': {
                    this.pushCharToken(TokenKind.COLON);
                    continue block17;
                }
                case ';': {
                    this.pushCharToken(TokenKind.SEMICOLON);
                    continue block17;
                }
                case '\'': {
                    this.lexQuotedStringLiteral();
                    continue block17;
                }
                case '\"': {
                    this.lexDoubleQuotedStringLiteral();
                    continue block17;
                }
                case '@': {
                    this.pushCharToken(TokenKind.REFERENCE);
                    continue block17;
                }
                case '\u0000': {
                    ++this.pos;
                    continue block17;
                }
                case '\\': {
                    throw new StreamDefinitionException(this.expressionString, this.pos, XDDSLMessages.UNEXPECTED_ESCAPE_CHAR, new Object[0]);
                }
            }
            throw new StreamDefinitionException(this.expressionString, this.pos, XDDSLMessages.UNEXPECTED_DATA, Character.valueOf(ch).toString());
        }
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    private void lexQuotedStringLiteral() {
        int start = this.pos;
        boolean terminated = false;
        while (!terminated) {
            ++this.pos;
            char ch = this.toProcess[this.pos];
            if (ch == '\'') {
                if (this.toProcess[this.pos + 1] == '\'') {
                    ++this.pos;
                } else {
                    terminated = true;
                }
            }
            if (ch != '\u0000') continue;
            throw new StreamDefinitionException(this.expressionString, start, XDDSLMessages.NON_TERMINATING_QUOTED_STRING, new Object[0]);
        }
        ++this.pos;
        this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subarray(start, this.pos), start, this.pos));
    }

    private void lexDoubleQuotedStringLiteral() {
        int start = this.pos;
        boolean terminated = false;
        while (!terminated) {
            ++this.pos;
            char ch = this.toProcess[this.pos];
            if (ch == '\"') {
                if (this.toProcess[this.pos + 1] == '\"') {
                    ++this.pos;
                } else {
                    terminated = true;
                }
            }
            if (ch != '\u0000') continue;
            throw new StreamDefinitionException(this.expressionString, start, XDDSLMessages.NON_TERMINATING_DOUBLE_QUOTED_STRING, new Object[0]);
        }
        ++this.pos;
        this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subarray(start, this.pos), start, this.pos));
    }

    private void lexIdentifier() {
        int start = this.pos;
        do {
            ++this.pos;
        } while (this.isIdentifier(this.toProcess[this.pos]));
        char[] subarray = this.subarray(start, this.pos);
        this.tokens.add(new Token(TokenKind.IDENTIFIER, subarray, start, this.pos));
    }

    private boolean isArgValueIdentifierTerminator(char ch, boolean quoteOpen) {
        return ch == '|' && !quoteOpen || ch == ';' && !quoteOpen || ch == '\u0000' || ch == ' ' && !quoteOpen || ch == '\t' && !quoteOpen || ch == '>' && !quoteOpen || ch == '\r' || ch == '\n';
    }

    private void lexArgValueIdentifier() {
        int start = this.pos;
        boolean quoteOpen = false;
        int quoteClosedCount = 0;
        Character quoteInUse = null;
        if (this.isQuote(this.toProcess[this.pos])) {
            quoteOpen = true;
            quoteInUse = Character.valueOf(this.toProcess[this.pos++]);
        }
        do {
            char ch = this.toProcess[this.pos];
            if (quoteInUse != null && ch == quoteInUse.charValue() || quoteInUse == null && this.isQuote(ch)) {
                if (quoteInUse != null && quoteInUse.charValue() == '\'' && ch == '\'' && this.toProcess[this.pos + 1] == '\'') {
                    ++this.pos;
                } else {
                    boolean bl = quoteOpen = !quoteOpen;
                    if (!quoteOpen) {
                        ++quoteClosedCount;
                    }
                }
            }
            ++this.pos;
        } while (!this.isArgValueIdentifierTerminator(this.toProcess[this.pos], quoteOpen));
        char[] subarray = null;
        if (quoteClosedCount < 2 && this.sameQuotes(start, this.pos - 1)) {
            this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subarray(start, this.pos), start, this.pos));
        } else {
            subarray = this.subarray(start, this.pos);
            this.tokens.add(new Token(TokenKind.IDENTIFIER, subarray, start, this.pos));
        }
    }

    private boolean sameQuotes(int pos1, int pos2) {
        if (this.toProcess[pos1] == '\'') {
            return this.toProcess[pos2] == '\'';
        }
        if (this.toProcess[pos1] == '\"') {
            return this.toProcess[pos2] == '\"';
        }
        return false;
    }

    private char[] subarray(int start, int end) {
        char[] result = new char[end - start];
        System.arraycopy(this.toProcess, start, result, 0, end - start);
        return result;
    }

    private boolean isTwoCharToken(TokenKind kind) {
        Assert.isTrue((kind.tokenChars.length == 2 ? 1 : 0) != 0);
        Assert.isTrue((this.toProcess[this.pos] == kind.tokenChars[0] ? 1 : 0) != 0);
        return this.toProcess[this.pos + 1] == kind.tokenChars[1];
    }

    private void pushCharToken(TokenKind kind) {
        this.tokens.add(new Token(kind, this.pos, this.pos + 1));
        ++this.pos;
    }

    private void pushPairToken(TokenKind kind) {
        this.tokens.add(new Token(kind, this.pos, this.pos + 2));
        this.pos += 2;
    }

    private boolean isIdentifier(char ch) {
        return this.isAlphabetic(ch) || this.isDigit(ch) || ch == '_' || ch == '$' || ch == '-';
    }

    private boolean isQuote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    private boolean isDigit(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (flags[ch] & 1) != 0;
    }

    private boolean isAlphabetic(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (flags[ch] & 4) != 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.expressionString).append("\n");
        for (int i = 0; i < this.pos; ++i) {
            s.append(" ");
        }
        s.append("^\n");
        s.append(this.tokens).append("\n");
        return s.toString();
    }

    static {
        int ch = 48;
        while (ch <= 57) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 3);
        }
        ch = 65;
        while (ch <= 70) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 2);
        }
        ch = 97;
        while (ch <= 102) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 2);
        }
        ch = 65;
        while (ch <= 90) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 4);
        }
        ch = 97;
        while (ch <= 122) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 4);
        }
    }
}

