/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

public enum TokenKind {
    IDENTIFIER,
    DOUBLE_MINUS("--"),
    EQUALS("="),
    AND("&"),
    PIPE("|"),
    NEWLINE("\n"),
    COLON(":"),
    GT(">"),
    SEMICOLON(";"),
    REFERENCE("@"),
    DOT("."),
    LITERAL_STRING;

    char[] tokenChars;
    private boolean hasPayload;

    private TokenKind(String tokenString) {
        this.tokenChars = tokenString.toCharArray();
        this.hasPayload = this.tokenChars.length == 0;
    }

    private TokenKind() {
        this("");
    }

    public String toString() {
        return this.name() + (this.tokenChars.length != 0 ? "(" + new String(this.tokenChars) + ")" : "");
    }

    public boolean hasPayload() {
        return this.hasPayload;
    }

    public int getLength() {
        return this.tokenChars.length;
    }

    public char[] getTokenChars() {
        return this.tokenChars;
    }
}

