/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.util.List;
import org.springframework.xd.dirt.stream.dsl.AstNode;
import org.springframework.xd.dirt.stream.dsl.ModuleNode;
import org.springframework.xd.dirt.stream.dsl.SinkChannelNode;
import org.springframework.xd.dirt.stream.dsl.SourceChannelNode;
import org.springframework.xd.dirt.stream.dsl.StreamLookupEnvironment;

public class StreamNode
extends AstNode {
    private final String streamText;
    private final String streamName;
    private final List<ModuleNode> moduleNodes;
    private SourceChannelNode sourceChannelNode;
    private SinkChannelNode sinkChannelNode;

    public StreamNode(String streamText, String streamName, List<ModuleNode> moduleNodes, SourceChannelNode sourceChannelNode, SinkChannelNode sinkChannelNode) {
        super(moduleNodes.get(0).getStartPos(), moduleNodes.get(moduleNodes.size() - 1).getEndPos());
        this.streamText = streamText;
        this.streamName = streamName;
        this.moduleNodes = moduleNodes;
        this.sourceChannelNode = sourceChannelNode;
        this.sinkChannelNode = sinkChannelNode;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (this.getStreamName() != null) {
            s.append(this.getStreamName()).append(" = ");
        }
        if (this.sourceChannelNode != null) {
            s.append(this.sourceChannelNode.stringify(includePositionalInfo));
        }
        for (ModuleNode moduleNode : this.moduleNodes) {
            s.append(moduleNode.stringify(includePositionalInfo));
        }
        if (this.sinkChannelNode != null) {
            s.append(this.sinkChannelNode.stringify(includePositionalInfo));
        }
        s.append("]");
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getStreamName() != null) {
            s.append(this.getStreamName()).append(" = ");
        }
        if (this.sourceChannelNode != null) {
            s.append(this.sourceChannelNode.toString());
        }
        for (int m = 0; m < this.moduleNodes.size(); ++m) {
            ModuleNode moduleNode = this.moduleNodes.get(m);
            s.append(moduleNode.toString());
            if (m + 1 >= this.moduleNodes.size()) continue;
            s.append(" | ");
        }
        if (this.sinkChannelNode != null) {
            s.append(this.sinkChannelNode.toString());
        }
        return s.toString();
    }

    public List<ModuleNode> getModuleNodes() {
        return this.moduleNodes;
    }

    public SourceChannelNode getSourceChannelNode() {
        return this.sourceChannelNode;
    }

    public SinkChannelNode getSinkChannelNode() {
        return this.sinkChannelNode;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public ModuleNode getModule(String moduleName) {
        for (ModuleNode moduleNode : this.moduleNodes) {
            if (!moduleNode.getName().equals(moduleName)) continue;
            return moduleNode;
        }
        return null;
    }

    public void resolve(StreamLookupEnvironment env, String expressionString) {
        if (this.sourceChannelNode != null) {
            this.sourceChannelNode.resolve(env, expressionString);
        }
    }

    public int getIndexOfLabel(String labelOrModuleName) {
        for (int m = 0; m < this.moduleNodes.size(); ++m) {
            ModuleNode moduleNode = this.moduleNodes.get(m);
            if (!moduleNode.getLabelName().equals(labelOrModuleName)) continue;
            return m;
        }
        return -1;
    }

    public String getStreamData() {
        return this.toString();
    }

    public String getStreamText() {
        return this.streamText;
    }

    public String getName() {
        return this.streamName;
    }
}

