/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import org.springframework.xd.dirt.stream.dsl.XDDSLMessages;

public class StreamDefinitionException
extends RuntimeException {
    protected String expressionString;
    protected int position;
    protected XDDSLMessages message;
    protected Object[] inserts;

    public StreamDefinitionException(String expressionString, int position, XDDSLMessages message, Object ... inserts) {
        super(message.formatMessage(position, inserts));
        this.position = position;
        this.message = message;
        this.inserts = inserts;
        this.expressionString = expressionString;
    }

    @Override
    public String getMessage() {
        StringBuilder s = new StringBuilder();
        if (this.message != null) {
            s.append(this.message.formatMessage(this.position, this.inserts));
        } else {
            s.append(super.getMessage());
        }
        if (this.expressionString != null && this.expressionString.length() > 0) {
            s.append("\n").append(this.expressionString).append("\n");
        }
        if (this.position >= 0) {
            for (int i = 0; i < this.position; ++i) {
                s.append(' ');
            }
            s.append("^\n");
        }
        return s.toString();
    }

    public XDDSLMessages getMessageCode() {
        return this.message;
    }

    public Object[] getInserts() {
        return this.inserts;
    }

    public final String getExpressionString() {
        return this.expressionString;
    }

    public final int getPosition() {
        return this.position;
    }
}

