/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.stream.dsl.ArgumentNode;
import org.springframework.xd.dirt.stream.dsl.ChannelNode;
import org.springframework.xd.dirt.stream.dsl.ChannelType;
import org.springframework.xd.dirt.stream.dsl.CheckpointedStreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.LabelNode;
import org.springframework.xd.dirt.stream.dsl.ModuleNode;
import org.springframework.xd.dirt.stream.dsl.SinkChannelNode;
import org.springframework.xd.dirt.stream.dsl.SourceChannelNode;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.StreamLookupEnvironment;
import org.springframework.xd.dirt.stream.dsl.StreamNode;
import org.springframework.xd.dirt.stream.dsl.Token;
import org.springframework.xd.dirt.stream.dsl.TokenKind;
import org.springframework.xd.dirt.stream.dsl.Tokenizer;
import org.springframework.xd.dirt.stream.dsl.XDDSLMessages;

public class StreamConfigParser
implements StreamLookupEnvironment {
    private String expressionString;
    private List<Token> tokenStream;
    private int tokenStreamLength;
    private int tokenStreamPointer;
    private int lastGoodPoint;
    private CrudRepository<? extends BaseDefinition, String> repository;

    public StreamConfigParser(CrudRepository<? extends BaseDefinition, String> repository) {
        this.repository = repository;
    }

    public StreamNode parse(String stream) {
        return this.parse(null, stream);
    }

    public StreamNode parse(String name, String stream) {
        this.expressionString = stream;
        Tokenizer tokenizer = new Tokenizer(this.expressionString);
        this.tokenStream = tokenizer.getTokens();
        this.tokenStreamLength = this.tokenStream.size();
        this.tokenStreamPointer = 0;
        StreamNode ast = this.eatStream();
        if (ast.getName() != null && !StreamConfigParser.isValidStreamName(ast.getName())) {
            throw new StreamDefinitionException(ast.getName(), 0, XDDSLMessages.ILLEGAL_STREAM_NAME, ast.getName());
        }
        if (name != null && !StreamConfigParser.isValidStreamName(name)) {
            throw new StreamDefinitionException(name, 0, XDDSLMessages.ILLEGAL_STREAM_NAME, name);
        }
        LinkedHashMap<String, ModuleNode> alreadySeen = new LinkedHashMap<String, ModuleNode>();
        for (int m = 0; m < ast.getModuleNodes().size(); ++m) {
            ModuleNode node = ast.getModuleNodes().get(m);
            ModuleNode previous = alreadySeen.put(node.getLabelName(), node);
            if (previous == null) continue;
            String duplicate = node.getLabelName();
            int previousIndex = new ArrayList(alreadySeen.keySet()).indexOf(duplicate);
            throw new StreamDefinitionException(stream, node.startpos, XDDSLMessages.DUPLICATE_LABEL, duplicate, previous.getName(), previousIndex, node.getName(), m);
        }
        if (ast.getModule(name) != null) {
            throw new StreamDefinitionException(stream, stream.indexOf(name), XDDSLMessages.STREAM_NAME_MATCHING_MODULE_NAME, name);
        }
        if (this.moreTokens()) {
            throw new StreamDefinitionException(this.expressionString, this.peekToken().startpos, XDDSLMessages.MORE_INPUT, this.toString(this.nextToken()));
        }
        ast.resolve(this, this.expressionString);
        return ast;
    }

    private String maybeEatStreamName() {
        String streamName = null;
        if (this.lookAhead(1, TokenKind.EQUALS)) {
            if (this.peekToken(TokenKind.IDENTIFIER)) {
                streamName = this.eatToken((TokenKind)TokenKind.IDENTIFIER).data;
                this.nextToken();
            } else {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.ILLEGAL_STREAM_NAME, this.toString(this.peekToken()));
            }
        }
        return streamName;
    }

    private StreamNode eatStream() {
        String streamName = this.maybeEatStreamName();
        SourceChannelNode sourceChannelNode = this.maybeEatSourceChannel();
        boolean bridge = false;
        if (sourceChannelNode != null && this.looksLikeChannel() && this.noMorePipes()) {
            bridge = true;
        }
        List<ModuleNode> moduleNodes = null;
        if (bridge) {
            --this.tokenStreamPointer;
            moduleNodes = new ArrayList<ModuleNode>();
            moduleNodes.add(new ModuleNode(null, "bridge", this.peekToken().startpos, this.peekToken().endpos, null));
        } else {
            moduleNodes = this.eatModuleList();
        }
        SinkChannelNode sinkChannelNode = this.maybeEatSinkChannel();
        if (this.moreTokens()) {
            Token t = this.peekToken();
            this.raiseException(t.startpos, XDDSLMessages.UNEXPECTED_DATA_AFTER_STREAMDEF, this.toString(t));
        }
        StreamNode streamNode = new StreamNode(this.expressionString, streamName, moduleNodes, sourceChannelNode, sinkChannelNode);
        return streamNode;
    }

    private boolean noMorePipes() {
        return this.noMorePipes(this.tokenStreamPointer);
    }

    private boolean noMorePipes(int tp) {
        while (tp < this.tokenStreamLength) {
            if (this.tokenStream.get(tp++).getKind() != TokenKind.PIPE) continue;
            return false;
        }
        return true;
    }

    private boolean looksLikeChannel() {
        return this.looksLikeChannel(this.tokenStreamPointer);
    }

    private boolean looksLikeChannel(int tp) {
        String prefix;
        return this.moreTokens() && this.tokenStream.get(tp).getKind() == TokenKind.IDENTIFIER && this.isLegalChannelPrefix(prefix = this.tokenStream.get((int)tp).data) && this.tokenStreamPointer + 1 < this.tokenStream.size() && this.tokenStream.get(tp + 1).getKind() == TokenKind.COLON;
    }

    private SourceChannelNode maybeEatSourceChannel() {
        boolean gtBeforePipe = false;
        for (int tp = this.tokenStreamPointer; tp < this.tokenStreamLength; ++tp) {
            Token t = this.tokenStream.get(tp);
            if (t.getKind() == TokenKind.GT) {
                gtBeforePipe = true;
                break;
            }
            if (t.getKind() == TokenKind.PIPE) break;
        }
        if (!gtBeforePipe || !this.looksLikeChannel(this.tokenStreamPointer)) {
            return null;
        }
        ChannelNode channel = this.eatChannelReference(true);
        Token gt = this.eatToken(TokenKind.GT);
        return new SourceChannelNode(channel, gt.endpos);
    }

    private SinkChannelNode maybeEatSinkChannel() {
        SinkChannelNode sinkChannelNode = null;
        if (this.peekToken(TokenKind.GT)) {
            Token gt = this.eatToken(TokenKind.GT);
            ChannelNode channelNode = this.eatChannelReference(false);
            sinkChannelNode = new SinkChannelNode(channelNode, gt.startpos);
        }
        return sinkChannelNode;
    }

    private boolean isLegalChannelPrefix(String string) {
        return string.equals(ChannelPrefix.queue.toString()) || string.equals(ChannelPrefix.topic.toString()) || string.equals(ChannelPrefix.tap.toString());
    }

    private ChannelNode eatChannelReference(boolean tapAllowed) {
        Token firstToken = this.nextToken();
        if (!firstToken.isIdentifier() || !this.isLegalChannelPrefix(firstToken.data)) {
            this.raiseException(firstToken.startpos, tapAllowed ? XDDSLMessages.EXPECTED_CHANNEL_PREFIX_QUEUE_TOPIC_TAP : XDDSLMessages.EXPECTED_CHANNEL_PREFIX_QUEUE_TOPIC, this.toString(firstToken));
        }
        ArrayList<Token> channelScopeComponents = new ArrayList<Token>();
        channelScopeComponents.add(firstToken);
        while (this.peekToken(TokenKind.COLON)) {
            if (!this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_CHANNEL_DEFINITION, new Object[0]);
            }
            this.nextToken();
            if (!this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_CHANNEL_DEFINITION, new Object[0]);
            }
            channelScopeComponents.add(this.eatToken(TokenKind.IDENTIFIER));
        }
        ArrayList<Token> channelReferenceComponents = new ArrayList<Token>();
        if (tapAllowed && firstToken.data.equalsIgnoreCase("tap")) {
            if (this.peekToken(TokenKind.DOT)) {
                String tokenData;
                if (channelScopeComponents.size() < 3) {
                    this.raiseException(firstToken.startpos, XDDSLMessages.TAP_NEEDS_THREE_COMPONENTS, new Object[0]);
                }
                if (!(tokenData = ((Token)channelScopeComponents.get((int)1)).data).equalsIgnoreCase("stream") && !tokenData.equalsIgnoreCase("job")) {
                    this.raiseException(this.peekToken().startpos, XDDSLMessages.ONLY_A_TAP_ON_A_STREAM_OR_JOB_CAN_BE_INDEXED, new Object[0]);
                }
            }
            while (this.peekToken(TokenKind.DOT)) {
                if (!this.isNextTokenAdjacent()) {
                    this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_CHANNEL_DEFINITION, new Object[0]);
                }
                this.nextToken();
                if (!this.isNextTokenAdjacent()) {
                    this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_CHANNEL_DEFINITION, new Object[0]);
                }
                channelReferenceComponents.add(this.eatToken(TokenKind.IDENTIFIER));
            }
        } else if (this.peekToken(TokenKind.DOT)) {
            if (tapAllowed) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.ONLY_A_TAP_ON_A_STREAM_OR_JOB_CAN_BE_INDEXED, new Object[0]);
            } else {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.CHANNEL_INDEXING_NOT_ALLOWED, new Object[0]);
            }
        }
        ChannelType channelType = null;
        if (firstToken.data.equalsIgnoreCase("tap")) {
            if (channelScopeComponents.size() < 3) {
                this.raiseException(firstToken.startpos, XDDSLMessages.TAP_NEEDS_THREE_COMPONENTS, new Object[0]);
            }
            Token tappingToken = (Token)channelScopeComponents.get(1);
            String tapping = tappingToken.data.toLowerCase();
            channelScopeComponents.remove(0);
            if (tapping.equals("stream")) {
                channelType = ChannelType.TAP_STREAM;
            } else if (tapping.equals("job")) {
                channelType = ChannelType.TAP_JOB;
            } else if (tapping.equals("queue")) {
                channelType = ChannelType.TAP_QUEUE;
            } else if (tapping.equals("topic")) {
                channelType = ChannelType.TAP_TOPIC;
            } else {
                this.raiseException(tappingToken.startpos, XDDSLMessages.NOT_ALLOWED_TO_TAP_THAT, tappingToken.data);
            }
        } else {
            if (firstToken.data.equalsIgnoreCase("queue")) {
                channelType = ChannelType.QUEUE;
            } else if (firstToken.data.equalsIgnoreCase("topic")) {
                channelType = ChannelType.TOPIC;
            }
            if (channelScopeComponents.size() >= 3) {
                channelScopeComponents.remove(0);
            }
        }
        int endpos = ((Token)channelScopeComponents.get((int)(channelScopeComponents.size() - 1))).endpos;
        if (!channelReferenceComponents.isEmpty()) {
            endpos = ((Token)channelReferenceComponents.get((int)(channelReferenceComponents.size() - 1))).endpos;
        }
        return new ChannelNode(channelType, firstToken.startpos, endpos, this.tokenListToStringList(channelScopeComponents), this.tokenListToStringList(channelReferenceComponents));
    }

    private List<String> tokenListToStringList(List<Token> tokens) {
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> data = new ArrayList<String>();
        for (Token token : tokens) {
            data.add(token.data);
        }
        return data;
    }

    private List<ModuleNode> eatModuleList() {
        ArrayList<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
        moduleNodes.add(this.eatModule());
        while (this.moreTokens()) {
            Token t = this.peekToken();
            if (t.kind != TokenKind.PIPE) break;
            this.nextToken();
            moduleNodes.add(this.eatModule());
        }
        return moduleNodes;
    }

    private ModuleNode eatModule() {
        Token label = null;
        Token name = this.nextToken();
        if (!name.isKind(TokenKind.IDENTIFIER)) {
            this.raiseException(name.startpos, XDDSLMessages.EXPECTED_MODULENAME, name.data != null ? name.data : new String(name.getKind().tokenChars));
        }
        if (this.peekToken(TokenKind.COLON)) {
            if (!this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_BETWEEN_LABEL_NAME_AND_COLON, new Object[0]);
            }
            this.nextToken();
            label = name;
            name = this.eatToken(TokenKind.IDENTIFIER);
        }
        Token moduleName = name;
        this.checkpoint();
        ArgumentNode[] args = this.maybeEatModuleArgs();
        int startpos = label != null ? label.startpos : moduleName.startpos;
        return new ModuleNode(this.toLabelNode(label), moduleName.data, startpos, moduleName.endpos, args);
    }

    private LabelNode toLabelNode(Token label) {
        if (label == null) {
            return null;
        }
        return new LabelNode(label.data, label.startpos, label.endpos);
    }

    private ArgumentNode[] maybeEatModuleArgs() {
        ArrayList<ArgumentNode> args = null;
        if (this.peekToken(TokenKind.DOUBLE_MINUS) && this.isNextTokenAdjacent()) {
            this.raiseException(this.peekToken().startpos, XDDSLMessages.EXPECTED_WHITESPACE_AFTER_MODULE_BEFORE_ARGUMENT, new Object[0]);
        }
        while (this.peekToken(TokenKind.DOUBLE_MINUS)) {
            Token dashDash = this.nextToken();
            if (this.peekToken(TokenKind.IDENTIFIER) && !this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_BEFORE_ARG_NAME, new Object[0]);
            }
            List<Token> argNameComponents = this.eatDottedName();
            if (this.peekToken(TokenKind.EQUALS) && !this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_BEFORE_ARG_EQUALS, new Object[0]);
            }
            this.eatToken(TokenKind.EQUALS);
            if (this.peekToken(TokenKind.IDENTIFIER) && !this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_BEFORE_ARG_VALUE, new Object[0]);
            }
            Token t = this.peekToken();
            String argValue = this.eatArgValue();
            this.checkpoint();
            if (args == null) {
                args = new ArrayList<ArgumentNode>();
            }
            args.add(new ArgumentNode(this.data(argNameComponents), argValue, dashDash.startpos, t.endpos));
        }
        return args == null ? null : args.toArray(new ArgumentNode[args.size()]);
    }

    private String eatArgValue() {
        Token t = this.nextToken();
        String argValue = null;
        if (t.getKind() == TokenKind.IDENTIFIER) {
            argValue = t.data;
        } else if (t.getKind() == TokenKind.LITERAL_STRING) {
            String quotesUsed = t.data.substring(0, 1);
            argValue = t.data.substring(1, t.data.length() - 1).replace(quotesUsed + quotesUsed, quotesUsed);
        } else {
            this.raiseException(t.startpos, XDDSLMessages.EXPECTED_ARGUMENT_VALUE, t.data);
        }
        return argValue;
    }

    private Token eatToken(TokenKind expectedKind) {
        Token t = this.nextToken();
        if (t == null) {
            this.raiseException(this.expressionString.length(), XDDSLMessages.OOD, new Object[0]);
        }
        if (t.kind != expectedKind) {
            this.raiseException(t.startpos, XDDSLMessages.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t.getKind().toString().toLowerCase() + (t.data == null ? "" : "(" + t.data + ")"));
        }
        return t;
    }

    private boolean peekToken(TokenKind desiredTokenKind) {
        return this.peekToken(desiredTokenKind, false);
    }

    private boolean lookAhead(int distance, TokenKind desiredTokenKind) {
        if (this.tokenStreamPointer + distance >= this.tokenStream.size()) {
            return false;
        }
        Token t = this.tokenStream.get(this.tokenStreamPointer + distance);
        return t.kind == desiredTokenKind;
    }

    private List<Token> eatDottedName() {
        return this.eatDottedName(XDDSLMessages.NOT_EXPECTED_TOKEN);
    }

    private List<Token> eatDottedName(XDDSLMessages error) {
        ArrayList<Token> result = new ArrayList<Token>(3);
        Token name = this.nextToken();
        if (!name.isKind(TokenKind.IDENTIFIER)) {
            this.raiseException(name.startpos, error, name.data != null ? name.data : new String(name.getKind().tokenChars));
        }
        result.add(name);
        while (this.peekToken(TokenKind.DOT)) {
            if (!this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_DOTTED_NAME, new Object[0]);
            }
            result.add(this.nextToken());
            if (this.peekToken(TokenKind.IDENTIFIER) && !this.isNextTokenAdjacent()) {
                this.raiseException(this.peekToken().startpos, XDDSLMessages.NO_WHITESPACE_IN_DOTTED_NAME, new Object[0]);
            }
            result.add(this.eatToken(TokenKind.IDENTIFIER));
        }
        return result;
    }

    public static boolean isValidStreamName(String streamname) {
        if (streamname.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(streamname.charAt(0))) {
            return false;
        }
        int max = streamname.length();
        for (int i = 1; i < max; ++i) {
            char ch = streamname.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    private int startPos(Iterable<Token> many) {
        Iterator<Token> iterator = many.iterator();
        Assert.isTrue((boolean)iterator.hasNext(), (String)"list of tokens must not be empty");
        return iterator.next().startpos;
    }

    private int endPos(Iterable<Token> many) {
        int result = -1;
        for (Token t : many) {
            result = t.endpos;
        }
        Assert.isTrue((result != -1 ? 1 : 0) != 0, (String)"list of tokens must not be empty");
        return result;
    }

    private String data(Iterable<Token> many) {
        StringBuilder result = new StringBuilder();
        for (Token t : many) {
            if (t.getKind().hasPayload()) {
                result.append(t.data);
                continue;
            }
            result.append(t.getKind().tokenChars);
        }
        return result.toString();
    }

    private boolean peekToken(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t = this.peekToken();
        if (t.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.tokenStreamPointer;
            }
            return true;
        }
        return false;
    }

    private boolean moreTokens() {
        return this.tokenStreamPointer < this.tokenStream.size();
    }

    private Token nextToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            this.raiseException(this.expressionString.length(), XDDSLMessages.OOD, new Object[0]);
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private boolean isNextTokenAdjacent() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return false;
        }
        Token last = this.tokenStream.get(this.tokenStreamPointer - 1);
        Token next = this.tokenStream.get(this.tokenStreamPointer);
        return next.startpos == last.endpos;
    }

    private Token peekToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer);
    }

    private void raiseException(int pos, XDDSLMessages message, Object ... inserts) {
        throw new CheckpointedStreamDefinitionException(this.expressionString, pos, this.tokenStreamPointer, this.lastGoodPoint, this.tokenStream, message, inserts);
    }

    private void checkpoint() {
        this.lastGoodPoint = this.tokenStreamPointer;
    }

    private String toString(Token t) {
        if (t.getKind().hasPayload()) {
            return t.stringValue();
        }
        return new String(t.kind.getTokenChars());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.tokenStream).append("\n");
        s.append("tokenStreamPointer=" + this.tokenStreamPointer).append("\n");
        return s.toString();
    }

    @Override
    public StreamNode lookupStream(String name) {
        BaseDefinition baseDefinition;
        if (this.repository != null && (baseDefinition = (BaseDefinition)this.repository.findOne((Serializable)((Object)name))) != null) {
            StreamNode streamNode = new StreamConfigParser(this.repository).parse(baseDefinition.getDefinition());
            return streamNode;
        }
        return null;
    }

    static enum ChannelPrefix {
        queue,
        tap,
        topic;

    }
}

