/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.util.Arrays;
import java.util.Properties;
import org.springframework.xd.dirt.stream.dsl.ArgumentNode;
import org.springframework.xd.dirt.stream.dsl.AstNode;
import org.springframework.xd.dirt.stream.dsl.LabelNode;

public class ModuleNode
extends AstNode {
    private static final ArgumentNode[] NO_ARGUMENTS = new ArgumentNode[0];
    private LabelNode label;
    private final String moduleName;
    private ArgumentNode[] arguments;

    public ModuleNode(LabelNode label, String moduleName, int startpos, int endpos, ArgumentNode[] arguments) {
        super(startpos, endpos);
        this.label = label;
        this.moduleName = moduleName;
        if (arguments != null) {
            this.arguments = Arrays.copyOf(arguments, arguments.length);
            this.endpos = this.arguments[this.arguments.length - 1].endpos;
        } else {
            this.arguments = NO_ARGUMENTS;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.label != null) {
            s.append(this.label.toString());
            s.append(" ");
        }
        s.append(this.moduleName);
        if (this.arguments != null) {
            for (int a = 0; a < this.arguments.length; ++a) {
                s.append(" --").append(this.arguments[a].getName()).append("=").append(this.arguments[a].getValue());
            }
        }
        return s.toString();
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        if (this.label != null) {
            s.append(this.label.stringify(includePositionalInfo));
            s.append(" ");
        }
        s.append("ModuleNode:").append(this.moduleName);
        if (this.arguments != null) {
            for (int a = 0; a < this.arguments.length; ++a) {
                s.append(" --").append(this.arguments[a].getName()).append("=").append(this.arguments[a].getValue());
            }
        }
        if (includePositionalInfo) {
            s.append(":");
            s.append(this.getStartPos()).append(">").append(this.getEndPos());
        }
        s.append(")");
        return s.toString();
    }

    public String getName() {
        return this.moduleName;
    }

    public ArgumentNode[] getArguments() {
        return this.arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null;
    }

    public String getLabelName() {
        return this.label != null ? this.label.getLabelName() : this.moduleName;
    }

    public Properties getArgumentsAsProperties() {
        Properties props = new Properties();
        if (this.arguments != null) {
            for (ArgumentNode argumentNode : this.arguments) {
                props.put(argumentNode.getName(), argumentNode.getValue());
            }
        }
        return props;
    }
}

