/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.xd.dirt.stream.dsl.AstNode;
import org.springframework.xd.dirt.stream.dsl.ChannelType;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.StreamLookupEnvironment;
import org.springframework.xd.dirt.stream.dsl.StreamNode;
import org.springframework.xd.dirt.stream.dsl.XDDSLMessages;

public class ChannelNode
extends AstNode {
    private ChannelType channelType;
    private List<String> nameComponents;
    private List<String> indexingElements;

    public ChannelNode(ChannelType channelType, int startpos, int endpos, List<String> nameElements, List<String> indexingElements) {
        super(startpos, endpos);
        this.channelType = channelType;
        this.nameComponents = nameElements;
        this.indexingElements = indexingElements;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        this.produceStringRepresentation(s);
        if (includePositionalInfo) {
            s.append(":");
            s.append(this.getStartPos()).append(">").append(this.getEndPos());
        }
        s.append(")");
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.produceStringRepresentation(s);
        return s.toString();
    }

    private void produceStringRepresentation(StringBuilder s) {
        int t = 0;
        if (this.channelType.isTap()) {
            s.append(this.channelType.getStringRepresentation());
        }
        if (this.nameComponents.size() > 0 && this.channelType.isTap() && this.nameComponents.get(0).equalsIgnoreCase(this.channelType.tapSource().name())) {
            t = 1;
        }
        int max = this.nameComponents.size();
        while (t < max) {
            s.append(this.nameComponents.get(t));
            if (t < this.nameComponents.size() - 1) {
                s.append(":");
            }
            ++t;
        }
        if (this.indexingElements.size() != 0) {
            int max2 = this.indexingElements.size();
            for (int t2 = 0; t2 < max2; ++t2) {
                s.append(".");
                s.append(this.indexingElements.get(t2));
            }
        }
    }

    String getChannelName() {
        StringBuilder s = new StringBuilder();
        if (this.channelType.isTap()) {
            s.append("tap:");
        }
        s.append(this.getNameComponents());
        s.append(this.getIndexingComponents());
        return s.toString();
    }

    private int getLengthOfPrefixPlusNameComponents() {
        int length = 0;
        if (this.channelType.isTap()) {
            length += 4;
        }
        for (int i = 0; i < this.nameComponents.size(); ++i) {
            if (i > 0) {
                ++length;
            }
            length += this.nameComponents.get(i).length();
        }
        return length;
    }

    private String getNameComponents() {
        StringBuilder s = new StringBuilder();
        int max = this.nameComponents.size();
        for (int t = 0; t < max; ++t) {
            if (t > 0) {
                s.append(":");
            }
            s.append(this.nameComponents.get(t));
        }
        return s.toString();
    }

    private String getIndexingComponents() {
        StringBuilder s = new StringBuilder();
        int max = this.indexingElements.size();
        for (int t = 0; t < max; ++t) {
            s.append(".");
            s.append(this.indexingElements.get(t));
        }
        return s.toString();
    }

    ChannelType getChannelType() {
        return this.channelType;
    }

    public ChannelNode copyOf() {
        return new ChannelNode(this.channelType, this.startpos, this.endpos, this.nameComponents, this.indexingElements);
    }

    public void resolve(StreamLookupEnvironment env, String expressionString) {
        if (this.channelType == ChannelType.TAP_STREAM) {
            String streamName = this.nameComponents.get(1);
            StreamNode sn = env.lookupStream(streamName);
            if (sn == null) {
                int offset = this.startpos + this.channelType.getStringRepresentation().length();
                throw new StreamDefinitionException(expressionString, offset, XDDSLMessages.UNRECOGNIZED_STREAM_REFERENCE, streamName);
            }
            if (this.indexingElements.isEmpty()) {
                this.indexingElements = new ArrayList<String>();
                this.indexingElements.add(sn.getModuleNodes().get(0).getName() + ".0");
            } else {
                try {
                    int index = Integer.parseInt(this.indexingElements.get(0));
                    this.indexingElements.remove(0);
                    this.indexingElements.add(0, sn.getModuleNodes().get(index).getName() + "." + index);
                }
                catch (NumberFormatException nfe) {
                    String indexString = this.toString(this.indexingElements);
                    int index = sn.getIndexOfLabel(indexString);
                    if (index != -1) {
                        this.indexingElements.clear();
                        this.indexingElements.add(0, sn.getModuleNodes().get(index).getName() + "." + index);
                    }
                    int offset = this.startpos + this.getLengthOfPrefixPlusNameComponents() + 1;
                    throw new StreamDefinitionException(expressionString, offset, XDDSLMessages.UNRECOGNIZED_MODULE_REFERENCE, indexString);
                }
            }
        }
    }

    private String toString(List<String> elements) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < elements.size(); ++i) {
            if (i > 0) {
                s.append('.');
            }
            s.append(elements.get(i));
        }
        return s.toString();
    }
}

