/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.CompletionProvider;
import org.springframework.xd.dirt.stream.completion.StacktraceFingerprintingCompletionRecoveryStrategy;
import org.springframework.xd.dirt.stream.dsl.CheckpointedStreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.Token;
import org.springframework.xd.dirt.stream.dsl.TokenKind;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class UnfinishedOptionNameRecoveryStrategy
extends StacktraceFingerprintingCompletionRecoveryStrategy<CheckpointedStreamDefinitionException> {
    private ModuleRegistry moduleRegistry;
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;

    @Autowired
    public UnfinishedOptionNameRecoveryStrategy(XDParser parser, ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        super(parser, CheckpointedStreamDefinitionException.class, "file --dir=foo --pa", "file --pa", "file --some.composed.", "file | filter | transform --expr");
        this.moduleRegistry = moduleRegistry;
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckpointedStreamDefinitionException exception, CompletionKind kind, int detailLevel, List<String> proposals) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        List<Token> tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!tokens.get(tokenPointer - 1).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        StringBuilder prefix = null;
        prefix = new StringBuilder();
        while (tokenPointer < tokens.size()) {
            Token t = tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                prefix.append(t.stringValue());
            } else {
                prefix.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        List<ModuleDescriptor> parsed = this.parser.parse("__dummy", safe, CompletionProvider.toParsingContext(kind));
        ModuleDescriptor lastModule = parsed.get(0);
        String lastModuleName = lastModule.getModuleName();
        ModuleType lastModuleType = lastModule.getType();
        ModuleDefinition lastModuleDefinition = this.moduleRegistry.findDefinition(lastModuleName, lastModuleType);
        HashSet alreadyPresentOptions = new HashSet(lastModule.getParameters().keySet());
        for (ModuleOption option : this.moduleOptionsMetadataResolver.resolve(lastModuleDefinition)) {
            if (!CompletionProvider.shouldShowOption(option, detailLevel) || alreadyPresentOptions.contains(option.getName()) || !option.getName().startsWith(prefix.toString())) continue;
            proposals.add(String.format("%s --%s=", safe, option.getName()));
        }
    }
}

