/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.StacktraceFingerprintingCompletionRecoveryStrategy;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class UnfinishedModuleNameRecoveryStrategy
extends StacktraceFingerprintingCompletionRecoveryStrategy<NoSuchModuleException> {
    private final ModuleRegistry moduleRegistry;

    @Autowired
    public UnfinishedModuleNameRecoveryStrategy(XDParser parser, ModuleRegistry moduleRegistry) {
        super(parser, NoSuchModuleException.class, "ht", "file | brid", "file | bridge | jd", "queue:foo > bar");
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public void addProposals(String dsl, NoSuchModuleException exception, CompletionKind kind, int detailLevel, List<String> proposals) {
        String modulePrefix = exception.getName();
        int index = dsl.lastIndexOf(modulePrefix);
        String chopped = dsl.substring(0, index);
        for (ModuleType expected : exception.getCandidateTypes()) {
            this.addModulesOfTypeWithPrefix(chopped, modulePrefix, expected, proposals);
        }
    }

    private void addModulesOfTypeWithPrefix(String beginning, String modulePrefix, ModuleType type, List<String> results) {
        List<ModuleDefinition> mods = this.moduleRegistry.findDefinitions(type);
        for (ModuleDefinition mod : mods) {
            if (!mod.getName().startsWith(modulePrefix)) continue;
            results.add(beginning + mod.getName());
        }
    }
}

