/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.CompletionRecoveryStrategy;
import org.springframework.xd.rest.domain.CompletionKind;

public abstract class StacktraceFingerprintingCompletionRecoveryStrategy<E extends Exception>
implements CompletionRecoveryStrategy<E> {
    private final Set<List<StackTraceElement>> fingerprints = new LinkedHashSet<List<StackTraceElement>>();
    protected final XDParser parser;
    private final Class<E> exceptionClass;
    private final String[] samples;

    public StacktraceFingerprintingCompletionRecoveryStrategy(XDParser parser, Class<E> exceptionClass, String ... samples) {
        Assert.notNull((Object)parser, (String)"parser should not be null");
        Assert.notNull(exceptionClass, (String)"exceptionClass should not be null");
        Assert.notEmpty((Object[])samples, (String)"samples should not be null or empty");
        this.parser = parser;
        this.exceptionClass = exceptionClass;
        this.samples = samples;
    }

    private void initFingerprints() {
        if (this.fingerprints.isEmpty()) {
            for (String sample : this.samples) {
                try {
                    this.parser.parse("__dummy", sample, ParsingContext.partial_stream);
                }
                catch (RuntimeException exception) {
                    if (this.exceptionClass.isAssignableFrom(exception.getClass())) {
                        this.computeFingerprint(exception);
                        continue;
                    }
                    throw exception;
                }
            }
        }
    }

    private void computeFingerprint(E exception) {
        boolean seenParserClass = false;
        ArrayList<StackTraceElement> fingerPrint = new ArrayList<StackTraceElement>();
        for (StackTraceElement frame : ((Throwable)exception).getStackTrace()) {
            if (frame.getClassName().equals(this.parser.getClass().getName())) {
                seenParserClass = true;
            } else if (seenParserClass) break;
            fingerPrint.add(frame);
        }
        this.fingerprints.add(fingerPrint);
    }

    private boolean fingerprintMatches(E exception, List<StackTraceElement> fingerPrint) {
        int i = 0;
        StackTraceElement[] stackTrace = ((Throwable)exception).getStackTrace();
        for (StackTraceElement frame : fingerPrint) {
            if (stackTrace[i++].equals(frame)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldTrigger(String dslStart, Exception exception, CompletionKind kind) {
        if (!this.exceptionClass.isAssignableFrom(exception.getClass())) {
            return false;
        }
        this.initFingerprints();
        for (List<StackTraceElement> fingerPrint : this.fingerprints) {
            if (!this.fingerprintMatches(exception, fingerPrint)) continue;
            return true;
        }
        return false;
    }
}

