/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.completion.CompletionExpansionStrategy;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class PipeIntoOtherModulesExpansionStrategy
implements CompletionExpansionStrategy {
    private ModuleRegistry moduleRegistry;

    @Autowired
    public PipeIntoOtherModulesExpansionStrategy(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public boolean shouldTrigger(String text, List<ModuleDescriptor> parseResult, CompletionKind kind) {
        return true;
    }

    @Override
    public void addProposals(String start, List<ModuleDescriptor> parseResult, CompletionKind kind, int detailLevel, List<String> proposals) {
        ModuleDescriptor lastModule = parseResult.get(0);
        ModuleType lastModuleType = lastModule.getType();
        if (kind == CompletionKind.stream && lastModuleType != ModuleType.sink) {
            this.addAllModulesOfType(start.endsWith(" ") ? start + "| " : start + " | ", ModuleType.processor, proposals);
            this.addAllModulesOfType(start.endsWith(" ") ? start + "| " : start + " | ", ModuleType.sink, proposals);
        }
        ModuleDescriptor firstModule = parseResult.get(parseResult.size() - 1);
        ModuleType firstModuleType = firstModule.getType();
        if (kind == CompletionKind.module && lastModuleType != ModuleType.sink) {
            this.addAllModulesOfType(start.endsWith(" ") ? start + "| " : start + " | ", ModuleType.processor, proposals);
            if (firstModuleType != ModuleType.source) {
                this.addAllModulesOfType(start.endsWith(" ") ? start + "| " : start + " | ", ModuleType.sink, proposals);
            }
        }
    }

    private void addAllModulesOfType(String beginning, ModuleType type, List<String> results) {
        List<ModuleDefinition> mods = this.moduleRegistry.findDefinitions(type);
        for (ModuleDefinition mod : mods) {
            results.add(beginning + mod.getName());
        }
    }
}

