/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.CompletionProvider;
import org.springframework.xd.dirt.stream.completion.StacktraceFingerprintingCompletionRecoveryStrategy;
import org.springframework.xd.dirt.stream.dsl.CheckpointedStreamDefinitionException;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class OptionNameAfterDashDashRecoveryStrategy
extends StacktraceFingerprintingCompletionRecoveryStrategy<CheckpointedStreamDefinitionException> {
    private ModuleRegistry moduleRegistry;
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;

    @Autowired
    public OptionNameAfterDashDashRecoveryStrategy(XDParser parser, ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        super(parser, CheckpointedStreamDefinitionException.class, "file --dir=foo --", "file --", "file | filter | transform --");
        this.moduleRegistry = moduleRegistry;
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckpointedStreamDefinitionException exception, CompletionKind kind, int detailLevel, List<String> proposals) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        List<ModuleDescriptor> parsed = this.parser.parse("__dummy", safe, CompletionProvider.toParsingContext(kind));
        ModuleDescriptor lastModule = parsed.get(0);
        String lastModuleName = lastModule.getModuleName();
        ModuleType lastModuleType = lastModule.getType();
        ModuleDefinition lastModuleDefinition = this.moduleRegistry.findDefinition(lastModuleName, lastModuleType);
        HashSet<String> alreadyPresentOptions = new HashSet<String>(lastModule.getParameters().keySet().size());
        for (String optionName : lastModule.getParameters().keySet()) {
            if (optionName.contains(".")) continue;
            alreadyPresentOptions.add(optionName);
        }
        for (ModuleOption option : this.moduleOptionsMetadataResolver.resolve(lastModuleDefinition)) {
            if (!CompletionProvider.shouldShowOption(option, detailLevel) || alreadyPresentOptions.contains(option.getName())) continue;
            proposals.add(String.format("%s --%s=", safe, option.getName()));
        }
    }
}

