/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.StacktraceFingerprintingCompletionRecoveryStrategy;
import org.springframework.xd.dirt.stream.dsl.CheckpointedStreamDefinitionException;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class ModulesAfterPipeRecoveryStrategy
extends StacktraceFingerprintingCompletionRecoveryStrategy<CheckpointedStreamDefinitionException> {
    private final ModuleRegistry moduleRegistry;

    @Autowired
    public ModulesAfterPipeRecoveryStrategy(XDParser parser, ModuleRegistry moduleRegistry) {
        super(parser, CheckpointedStreamDefinitionException.class, "file | filter |");
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public void addProposals(String start, CheckpointedStreamDefinitionException exception, CompletionKind kind, int detailLevel, List<String> proposals) {
        this.addAllModulesOfType(start.endsWith(" ") ? start : start + " ", ModuleType.processor, proposals);
        this.addAllModulesOfType(start.endsWith(" ") ? start : start + " ", ModuleType.sink, proposals);
    }

    private void addAllModulesOfType(String beginning, ModuleType type, List<String> results) {
        List<ModuleDefinition> mods = this.moduleRegistry.findDefinitions(type);
        for (ModuleDefinition mod : mods) {
            results.add(beginning + mod.getName());
        }
    }
}

