/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.StacktraceFingerprintingCompletionRecoveryStrategy;
import org.springframework.xd.dirt.stream.dsl.CheckpointedStreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.TokenKind;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class EmptyStartYieldsModulesRecoveryStrategy
extends StacktraceFingerprintingCompletionRecoveryStrategy<CheckpointedStreamDefinitionException> {
    private ModuleRegistry moduleRegistry;

    @Autowired
    public EmptyStartYieldsModulesRecoveryStrategy(XDParser parser, ModuleRegistry moduleRegistry) {
        super(parser, CheckpointedStreamDefinitionException.class, "", "queue:foo >");
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public void addProposals(String dsl, CheckpointedStreamDefinitionException exception, CompletionKind kind, int detailLevel, List<String> proposals) {
        if ("".equals(dsl)) {
            switch (kind) {
                case module: {
                    this.addAllModulesOfType(proposals, exception.getExpressionStringUntilCheckpoint(), ModuleType.processor);
                }
                case stream: {
                    this.addAllModulesOfType(proposals, exception.getExpressionStringUntilCheckpoint(), ModuleType.source);
                    break;
                }
                case job: {
                    this.addAllModulesOfType(proposals, exception.getExpressionStringUntilCheckpoint(), ModuleType.job);
                    break;
                }
            }
        } else if (exception.getTokenPointer() > 0) {
            Assert.isTrue((exception.getTokens().get(exception.getTokenPointer() - 1).getKind() == TokenKind.GT ? 1 : 0) != 0);
            switch (kind) {
                case stream: {
                    this.addAllModulesOfType(proposals, dsl, ModuleType.processor);
                    this.addAllModulesOfType(proposals, dsl, ModuleType.sink);
                    break;
                }
            }
        }
    }

    private void addAllModulesOfType(List<String> results, String start, ModuleType type) {
        String beginning = start.length() == 0 || start.endsWith(" ") ? start : start + " ";
        List<ModuleDefinition> mods = this.moduleRegistry.findDefinitions(type);
        for (ModuleDefinition mod : mods) {
            results.add(beginning + mod.getName());
        }
    }
}

