/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.completion.CompletionExpansionStrategy;
import org.springframework.xd.dirt.stream.completion.CompletionRecoveryStrategy;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.rest.domain.CompletionKind;

@Service
@Lazy
public class CompletionProvider {
    private static final int HIDDEN_OPTION_THRESHOLD = 2;
    private final XDParser parser;
    private final List<CompletionRecoveryStrategy<Exception>> completionRecoveryStrategies;
    private final List<CompletionExpansionStrategy> completionExpansionStrategies;

    public static boolean shouldShowOption(ModuleOption option, int detailLevel) {
        return !option.isHidden() || detailLevel >= 2;
    }

    @Autowired
    public CompletionProvider(XDParser parser, List<CompletionRecoveryStrategy<? extends Exception>> completionRecoveryStrategies, List<CompletionExpansionStrategy> completionExpansionStrategies) {
        this.parser = parser;
        List<CompletionRecoveryStrategy<? extends Exception>> o = completionRecoveryStrategies;
        this.completionRecoveryStrategies = o;
        this.completionExpansionStrategies = completionExpansionStrategies;
    }

    public List<String> complete(CompletionKind kind, String start, int detailLevel) {
        ArrayList<String> results = new ArrayList<String>();
        String name = "__dummy";
        List<ModuleDescriptor> parsed = null;
        try {
            parsed = this.parser.parse(name, start, CompletionProvider.toParsingContext(kind));
        }
        catch (Exception recoverable) {
            for (CompletionRecoveryStrategy<Exception> strategy : this.completionRecoveryStrategies) {
                if (!strategy.shouldTrigger(start, recoverable, kind)) continue;
                strategy.addProposals(start, recoverable, kind, detailLevel, results);
            }
            return results;
        }
        for (CompletionExpansionStrategy strategy : this.completionExpansionStrategies) {
            if (!strategy.shouldTrigger(start, parsed, kind)) continue;
            strategy.addProposals(start, parsed, kind, detailLevel, results);
        }
        return results;
    }

    static ParsingContext toParsingContext(CompletionKind kind) {
        switch (kind) {
            case stream: {
                return ParsingContext.partial_stream;
            }
            case module: {
                return ParsingContext.partial_module;
            }
            case job: {
                return ParsingContext.partial_job;
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }
}

