/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.completion.CompletionExpansionStrategy;
import org.springframework.xd.dirt.stream.completion.CompletionProvider;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.rest.domain.CompletionKind;

@Component
public class AddModuleOptionsExpansionStrategy
implements CompletionExpansionStrategy {
    private ModuleRegistry moduleRegistry;
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;

    @Autowired
    public AddModuleOptionsExpansionStrategy(ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        this.moduleRegistry = moduleRegistry;
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
    }

    @Override
    public boolean shouldTrigger(String text, List<ModuleDescriptor> parseResult, CompletionKind kind) {
        return true;
    }

    @Override
    public void addProposals(String text, List<ModuleDescriptor> parseResult, CompletionKind kind, int detailLevel, List<String> proposals) {
        ModuleDescriptor lastModule = parseResult.get(0);
        String lastModuleName = lastModule.getModuleName();
        ModuleType lastModuleType = lastModule.getType();
        ModuleDefinition lastModuleDefinition = this.moduleRegistry.findDefinition(lastModuleName, lastModuleType);
        HashSet alreadyPresentOptions = new HashSet(lastModule.getParameters().keySet());
        for (ModuleOption option : this.moduleOptionsMetadataResolver.resolve(lastModuleDefinition)) {
            if (!CompletionProvider.shouldShowOption(option, detailLevel) || alreadyPresentOptions.contains(option.getName())) continue;
            proposals.add(String.format("%s%s--%s=", text, text.endsWith(" ") ? "" : " ", option.getName()));
        }
    }
}

