/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.plugins.ModuleConfigurationException;
import org.springframework.xd.dirt.stream.DocumentParseResult;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.dsl.ArgumentNode;
import org.springframework.xd.dirt.stream.dsl.ModuleNode;
import org.springframework.xd.dirt.stream.dsl.SinkChannelNode;
import org.springframework.xd.dirt.stream.dsl.SourceChannelNode;
import org.springframework.xd.dirt.stream.dsl.StreamConfigParser;
import org.springframework.xd.dirt.stream.dsl.StreamDefinitionException;
import org.springframework.xd.dirt.stream.dsl.StreamNode;
import org.springframework.xd.dirt.stream.dsl.XDDSLMessages;
import org.springframework.xd.module.CompositeModuleDefinition;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.store.AbstractRepository;

public class XDStreamParser
implements XDParser {
    private final ModuleRegistry moduleRegistry;
    private final ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;
    private CrudRepository<? extends BaseDefinition, String> repository;

    public XDStreamParser(CrudRepository<? extends BaseDefinition, String> repository, ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        Assert.notNull((Object)moduleRegistry, (String)"moduleRegistry can not be null");
        Assert.notNull((Object)moduleOptionsMetadataResolver, (String)"moduleOptionsMetadataResolver can not be null");
        this.repository = repository;
        this.moduleRegistry = moduleRegistry;
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
    }

    public XDStreamParser(ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        this(null, moduleRegistry, moduleOptionsMetadataResolver);
    }

    @Override
    public List<ModuleDescriptor> parse(String name, String config, ParsingContext parsingContext) {
        StreamConfigParser parser = new StreamConfigParser(this.repository);
        StreamNode stream = parser.parse(name, config);
        return this.buildModuleDescriptors(name, config, parsingContext, stream, null);
    }

    private List<ModuleDescriptor> buildModuleDescriptors(String name, String rawDSL, ParsingContext parsingContext, StreamNode stream, List<Exception> errorAccumulator) {
        SinkChannelNode sinkChannel;
        LinkedList<ModuleDescriptor.Builder> builders = new LinkedList<ModuleDescriptor.Builder>();
        List<ModuleNode> moduleNodes = stream.getModuleNodes();
        for (int m = moduleNodes.size() - 1; m >= 0; --m) {
            ModuleNode moduleNode = moduleNodes.get(m);
            ModuleDescriptor.Builder builder = new ModuleDescriptor.Builder().setGroup(name).setModuleName(moduleNode.getName()).setModuleLabel(moduleNode.getLabelName()).setIndex(m);
            if (moduleNode.hasArguments()) {
                ArgumentNode[] arguments;
                for (ArgumentNode argument : arguments = moduleNode.getArguments()) {
                    builder.setParameter(argument.getName(), argument.getValue());
                }
            }
            builders.add(builder);
        }
        SourceChannelNode sourceChannel = stream.getSourceChannelNode();
        if (sourceChannel != null) {
            if (parsingContext.supportsNamedChannels()) {
                ((ModuleDescriptor.Builder)builders.getLast()).setSourceChannelName(sourceChannel.getChannelName());
            } else {
                throw new StreamDefinitionException(rawDSL, sourceChannel.getStartPos(), XDDSLMessages.NAMED_CHANNELS_UNSUPPORTED_HERE, new Object[0]);
            }
        }
        if ((sinkChannel = stream.getSinkChannelNode()) != null) {
            if (parsingContext.supportsNamedChannels()) {
                ((ModuleDescriptor.Builder)builders.getFirst()).setSinkChannelName(sinkChannel.getChannelName());
            } else {
                throw new StreamDefinitionException(rawDSL, sinkChannel.getChannelNode().getStartPos(), XDDSLMessages.NAMED_CHANNELS_UNSUPPORTED_HERE, new Object[0]);
            }
        }
        ArrayList<ModuleDescriptor> result = new ArrayList<ModuleDescriptor>(builders.size());
        for (ModuleDescriptor.Builder builder : builders) {
            ModuleType moduleType;
            try {
                moduleType = this.determineType(builder, builders.size() - 1, parsingContext);
            }
            catch (NoSuchModuleException nsme) {
                if (errorAccumulator != null) {
                    errorAccumulator.add(nsme);
                    moduleType = ModuleType.processor;
                }
                throw nsme;
            }
            builder.setType(moduleType);
            ModuleDefinition moduleDefinition = this.moduleRegistry.findDefinition(builder.getModuleName(), builder.getType());
            if (moduleDefinition != null) {
                builder.setModuleDefinition(moduleDefinition);
                ModuleOptionsMetadata optionsMetadata = this.moduleOptionsMetadataResolver.resolve(moduleDefinition);
                if (parsingContext.shouldBindAndValidate()) {
                    try {
                        optionsMetadata.interpolate(builder.getParameters());
                    }
                    catch (BindException e) {
                        ModuleConfigurationException mce = ModuleConfigurationException.fromBindException(builder.getModuleName(), builder.getType(), e);
                        if (errorAccumulator != null) {
                            errorAccumulator.add(mce);
                        }
                        throw mce;
                    }
                }
            }
            result.add(this.buildModuleDescriptor(builder));
        }
        return result;
    }

    private ModuleType determineType(ModuleDescriptor.Builder builder, int lastIndex, ParsingContext parsingContext) {
        ModuleType moduleType = this.determineTypeFromNamedChannels(builder, lastIndex, parsingContext);
        if (moduleType != null) {
            return moduleType;
        }
        String name = builder.getModuleName();
        int index = builder.getIndex();
        return this.resolveModuleType(name, parsingContext.allowed(ParsingContext.Position.of(index, lastIndex)));
    }

    private ModuleType determineTypeFromNamedChannels(ModuleDescriptor.Builder builder, int lastIndex, ParsingContext parsingContext) {
        if (parsingContext == ParsingContext.job && (builder.getSourceChannelName() != null || builder.getSinkChannelName() != null)) {
            throw new RuntimeException("TODO");
        }
        ModuleType type = null;
        String moduleName = builder.getModuleName();
        int index = builder.getIndex();
        if (builder.getSourceChannelName() != null) {
            type = index == lastIndex ? (builder.getSinkChannelName() != null ? ModuleType.processor : ModuleType.sink) : ModuleType.processor;
        } else if (builder.getSinkChannelName() != null) {
            type = index == 0 ? ModuleType.source : ModuleType.processor;
        }
        return type == null ? null : this.resolveModuleType(moduleName, type);
    }

    private ModuleDescriptor buildModuleDescriptor(ModuleDescriptor.Builder builder) {
        ModuleDefinition def = this.moduleRegistry.findDefinition(builder.getModuleName(), builder.getType());
        if (def != null && def.isComposed()) {
            String dsl = ((CompositeModuleDefinition)def).getDslDefinition();
            List<ModuleDescriptor> children = this.parse(def.getName(), dsl, ParsingContext.module);
            HashMap parameters = new HashMap(builder.getParameters());
            for (ModuleDescriptor moduleDescriptor : children) {
                for (String key : moduleDescriptor.getParameters().keySet()) {
                    String prefix = moduleDescriptor.getModuleName() + ".";
                    builder.setParameter(prefix + key, (String)moduleDescriptor.getParameters().get(key));
                }
            }
            for (Map.Entry entry : parameters.entrySet()) {
                builder.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
            ArrayList<ModuleDescriptor> list = new ArrayList<ModuleDescriptor>();
            for (ModuleDescriptor child : children) {
                ModuleDescriptor.Builder childBuilder = ModuleDescriptor.Builder.fromModuleDescriptor((ModuleDescriptor)child);
                childBuilder.setGroup(builder.getGroup() + "." + child.getModuleName());
                list.add(childBuilder.build());
            }
            builder.addChildren(list);
        }
        return builder.build();
    }

    private ModuleType resolveModuleType(String moduleName, ModuleType ... candidates) {
        for (ModuleType type : candidates) {
            ModuleDefinition def = this.moduleRegistry.findDefinition(moduleName, type);
            if (def == null) continue;
            return type;
        }
        throw new NoSuchModuleException(moduleName, candidates);
    }

    public static class MultiLineDocumentParser {
        private final XDStreamParser delegate;

        public MultiLineDocumentParser(XDStreamParser delegate) {
            this.delegate = delegate;
        }

        public DocumentParseResult parse(String[] document) {
            DocumentParseResult result = new DocumentParseResult(document.length);
            TransientDefinitionRepository transientRepository = new TransientDefinitionRepository();
            StreamConfigParser parser = new StreamConfigParser(transientRepository);
            int line = 1;
            for (String nameAndDefinitionPair : document) {
                try {
                    StreamNode stream = parser.parse(nameAndDefinitionPair);
                    String streamName = stream.getStreamName();
                    if (streamName == null) {
                        streamName = "UNKNOWN_" + line;
                    }
                    ArrayList<Exception> errorAccumulator = new ArrayList<Exception>();
                    List moduleDescriptors = this.delegate.buildModuleDescriptors(streamName, nameAndDefinitionPair, ParsingContext.partial_stream, stream, errorAccumulator);
                    StreamDefinition streamDefinition = new StreamDefinition(streamName, nameAndDefinitionPair);
                    transientRepository.save(streamDefinition);
                    result.success(moduleDescriptors, errorAccumulator);
                }
                catch (Exception e) {
                    result.failure(e);
                }
                ++line;
            }
            return result;
        }

        private class TransientDefinitionRepository
        extends AbstractRepository<BaseDefinition, String>
        implements CrudRepository<BaseDefinition, String> {
            private Map<String, BaseDefinition> store = new HashMap<String, BaseDefinition>();

            private TransientDefinitionRepository() {
            }

            public <S extends BaseDefinition> S save(S entity) {
                this.store.put(entity.getName(), entity);
                return entity;
            }

            public BaseDefinition findOne(String s) {
                BaseDefinition inMemory = this.store.get(s);
                return inMemory != null ? inMemory : (BaseDefinition)MultiLineDocumentParser.this.delegate.repository.findOne((Serializable)((Object)s));
            }

            public Iterable<BaseDefinition> findAll() {
                return Iterables.concat((Iterable)MultiLineDocumentParser.this.delegate.repository.findAll(), this.store.values());
            }

            public long count() {
                return (long)this.store.size() + MultiLineDocumentParser.this.delegate.repository.count();
            }

            public void delete(String s) {
                this.store.remove(s);
                MultiLineDocumentParser.this.delegate.repository.delete((Serializable)((Object)s));
            }

            public void delete(BaseDefinition entity) {
                this.store.remove(entity.getName());
                MultiLineDocumentParser.this.delegate.repository.delete((Serializable)((Object)entity.getName()));
            }

            public void deleteAll() {
                this.store.clear();
                MultiLineDocumentParser.this.delegate.repository.deleteAll();
            }
        }
    }
}

