/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import java.util.LinkedList;
import java.util.Map;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.StreamDefinitionRepository;
import org.springframework.xd.dirt.stream.XDStreamParser;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.rest.domain.support.DeploymentPropertiesFormat;

public class StreamFactory {
    private final XDStreamParser parser;

    public StreamFactory(StreamDefinitionRepository streamDefinitionRepository, ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        this.parser = new XDStreamParser((CrudRepository<? extends BaseDefinition, String>)streamDefinitionRepository, moduleRegistry, moduleOptionsMetadataResolver);
    }

    public Stream createStream(String name, Map<String, String> properties) {
        Assert.hasText((String)name, (String)"Stream name is required");
        Assert.notNull(properties, (String)"Stream properties are required");
        String definition = properties.get("definition");
        Assert.hasText((String)definition, (String)"Stream properties requires a 'definition' property");
        LinkedList<ModuleDescriptor> descriptors = new LinkedList<ModuleDescriptor>();
        for (ModuleDescriptor request : this.parser.parse(name, definition, ParsingContext.stream)) {
            descriptors.addFirst(request);
        }
        return new Stream.Builder().setName(name).setDeploymentProperties(DeploymentPropertiesFormat.parseDeploymentProperties((String)properties.get("deploymentProperties"))).setModuleDescriptors(descriptors).build();
    }
}

