/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.module.ModuleDefinition;

public abstract class StreamDefinitionRepositoryUtils {
    public static void saveDependencies(ModuleDependencyRepository moduleDependencyRepository, StreamDefinition streamDefinition) {
        StreamDefinitionRepositoryUtils.validate(moduleDependencyRepository, streamDefinition);
        List<ModuleDefinition> moduleDefinitions = streamDefinition.getModuleDefinitions();
        for (ModuleDefinition moduleDefinition : moduleDefinitions) {
            moduleDependencyRepository.store(moduleDefinition.getName(), moduleDefinition.getType(), "stream:" + streamDefinition.getName());
        }
    }

    public static void deleteDependencies(ModuleDependencyRepository moduleDependencyRepository, StreamDefinition streamDefinition) {
        StreamDefinitionRepositoryUtils.validate(moduleDependencyRepository, streamDefinition);
        List<ModuleDefinition> moduleDefinitions = streamDefinition.getModuleDefinitions();
        for (ModuleDefinition moduleDefinition : moduleDefinitions) {
            moduleDependencyRepository.delete(moduleDefinition.getName(), moduleDefinition.getType(), "stream:" + streamDefinition.getName());
        }
    }

    private static void validate(ModuleDependencyRepository moduleDependencyRepository, StreamDefinition streamDefinition) {
        Assert.notNull((Object)moduleDependencyRepository, (String)"No ModuleDependencyRepository specified");
        Assert.notNull((Object)streamDefinition, (String)"No StreamDefinition specified");
    }
}

