/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import org.springframework.xd.module.ModuleType;

public enum ParsingContext {
    stream(true, true, ModuleType.source, ModuleType.processor, ModuleType.sink),
    module(true, false, new ModuleType[]{ModuleType.source, ModuleType.processor}, new ModuleType[]{ModuleType.processor}, new ModuleType[]{ModuleType.processor, ModuleType.sink}),
    job(true, false, ModuleType.job, null, null),
    partial_stream(false, true, new ModuleType[]{ModuleType.source}, new ModuleType[]{ModuleType.processor}, new ModuleType[]{ModuleType.processor, ModuleType.sink}),
    partial_module(false, false, new ModuleType[]{ModuleType.source, ModuleType.processor}, new ModuleType[]{ModuleType.processor}, new ModuleType[]{ModuleType.processor, ModuleType.sink}),
    partial_job(false, false, ModuleType.job, null, null);

    private final ModuleType[][] allowed = new ModuleType[Position.values().length][];
    private final boolean bindAndValidate;
    private final boolean supportsNamedChannels;

    ModuleType[] allowed(Position position) {
        ModuleType[] result = this.allowed[position.ordinal()];
        if (result == null) {
            throw new IllegalArgumentException(String.format("A %s can't have a module at position '%s'", this.name(), position.name()));
        }
        return result;
    }

    public boolean shouldBindAndValidate() {
        return this.bindAndValidate;
    }

    public boolean supportsNamedChannels() {
        return this.supportsNamedChannels;
    }

    private ParsingContext(boolean bindAndValidate, boolean supportsNamedChannels, ModuleType atStart, ModuleType atMiddle, ModuleType atEnd) {
        this(bindAndValidate, supportsNamedChannels, new ModuleType[]{atStart}, new ModuleType[]{atMiddle}, new ModuleType[]{atEnd});
    }

    private ParsingContext(boolean bindAndValidate, boolean supportsNamedChannels, ModuleType[] atStart, ModuleType[] atMiddle, ModuleType[] atEnd) {
        this.bindAndValidate = bindAndValidate;
        this.supportsNamedChannels = supportsNamedChannels;
        this.allowed[0] = atStart;
        this.allowed[1] = atMiddle;
        this.allowed[2] = atEnd;
    }

    public static enum Position {
        start,
        middle,
        end;


        public static Position of(int index, int lastIndex) {
            if (index < 0) {
                throw new IllegalArgumentException("index can't be negative");
            }
            if (index == 0) {
                return start;
            }
            if (index < lastIndex) {
                return middle;
            }
            if (index == lastIndex) {
                return end;
            }
            throw new IllegalArgumentException("index can't be greater than lastIndex");
        }
    }
}

