/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentException;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentHandler;
import org.springframework.xd.dirt.stream.AbstractDeployer;
import org.springframework.xd.dirt.stream.BaseInstance;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.store.DomainRepository;

public abstract class AbstractInstancePersistingDeployer<D extends BaseDefinition, I extends BaseInstance<D>>
extends AbstractDeployer<D> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInstancePersistingDeployer.class);
    protected final DomainRepository<I, String> instanceRepository;
    protected final DeploymentHandler deploymentHandler;

    protected AbstractInstancePersistingDeployer(ZooKeeperConnection zkConnection, PagingAndSortingRepository<D, String> definitionRespository, DomainRepository<I, String> instanceRepository, XDParser parser, DeploymentHandler deploymentHandler, ParsingContext definitionKind) {
        super(zkConnection, definitionRespository, parser, definitionKind);
        this.instanceRepository = instanceRepository;
        this.deploymentHandler = deploymentHandler;
    }

    @Override
    protected void beforeDelete(D definition) {
        this.validateBeforeDelete(((BaseDefinition)definition).getName());
        if (this.instanceRepository.exists((Serializable)((Object)((BaseDefinition)definition).getName()))) {
            this.undeploy(((BaseDefinition)definition).getName());
        }
    }

    @Override
    public void undeploy(String name) {
        this.validateBeforeUndeploy(name);
        logger.trace("Undeploying {}", (Object)name);
        this.instanceRepository.delete(this.instanceRepository.findOne((Serializable)((Object)name)));
        this.undeployResource(name);
    }

    @Override
    public void deploy(String name, Map<String, String> properties) {
        this.validateBeforeDeploy(name, properties);
        Object definition = this.basicDeploy(name, properties);
        I instance = this.makeInstance(definition);
        this.instanceRepository.save(instance);
        this.deployResource(name);
    }

    @Override
    public void undeployAll() {
        for (BaseDefinition definition : this.findAll()) {
            String name = definition.getName();
            if (!this.instanceRepository.exists((Serializable)((Object)name))) continue;
            this.undeploy(name);
        }
    }

    @Override
    public void deleteAll() {
        this.undeployAll();
        super.deleteAll();
    }

    public Iterable<I> deploymentInfo(String first, String last) {
        return this.instanceRepository.findAllInRange((Serializable)((Object)first), true, (Serializable)((Object)last), true);
    }

    public BaseInstance<D> deploymentInfo(String id) {
        return (BaseInstance)this.instanceRepository.findOne((Serializable)((Object)id));
    }

    protected abstract I makeInstance(D var1);

    protected final void deployResource(String deploymentUnitName) {
        try {
            this.deploymentHandler.deploy(deploymentUnitName);
        }
        catch (Exception e) {
            throw new DeploymentException(deploymentUnitName, e);
        }
    }

    protected final void undeployResource(String deploymentUnitName) {
        try {
            this.deploymentHandler.undeploy(deploymentUnitName);
        }
        catch (Exception e) {
            throw new DeploymentException(deploymentUnitName, e);
        }
    }

    @Override
    public void validateBeforeUndeploy(String name) {
        BaseInstance instance;
        Assert.hasText((String)name, (String)"name cannot be blank or null");
        BaseDefinition definition = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (definition == null) {
            this.throwNoSuchDefinitionException(name);
        }
        if ((instance = (BaseInstance)this.instanceRepository.findOne((Serializable)((Object)name))) == null) {
            this.throwNotDeployedException(name);
        }
    }

    @Override
    public void validateBeforeDeploy(String name, Map<String, String> properties) {
        Assert.hasText((String)name, (String)"name cannot be blank or null");
        Assert.notNull(properties, (String)"properties cannot be null");
        BaseDefinition definition = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (definition == null) {
            this.throwNoSuchDefinitionException(name);
        }
        if (this.instanceRepository.exists((Serializable)((Object)name))) {
            this.throwAlreadyDeployedException(name);
        }
    }
}

