/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.ResourceDeployer;
import org.springframework.xd.dirt.job.dsl.ComposedJobUtil;
import org.springframework.xd.dirt.job.dsl.JobParser;
import org.springframework.xd.dirt.stream.AlreadyDeployedException;
import org.springframework.xd.dirt.stream.DefinitionAlreadyExistsException;
import org.springframework.xd.dirt.stream.DeploymentValidator;
import org.springframework.xd.dirt.stream.NoSuchDefinitionException;
import org.springframework.xd.dirt.stream.NotDeployedException;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.rest.domain.support.DeploymentPropertiesFormat;

public abstract class AbstractDeployer<D extends BaseDefinition>
implements ResourceDeployer<D>,
DeploymentValidator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeployer.class);
    private static final Pattern DEPLOYMENT_PROPERTY_PATTERN = Pattern.compile("module\\.([^\\.]+)\\.([^=]+)");
    private final PagingAndSortingRepository<D, String> repository;
    private final ZooKeeperConnection zkConnection;
    protected final XDParser parser;
    protected final JobParser composedJobParser;
    protected final ParsingContext definitionKind;

    protected AbstractDeployer(ZooKeeperConnection zkConnection, PagingAndSortingRepository<D, String> repository, XDParser parser, ParsingContext parsingContext) {
        Assert.notNull((Object)zkConnection, (String)"ZooKeeper connection cannot be null");
        Assert.notNull(repository, (String)"Repository cannot be null");
        Assert.notNull((Object)((Object)parsingContext), (String)"Entity type kind cannot be null");
        this.zkConnection = zkConnection;
        this.repository = repository;
        this.definitionKind = parsingContext;
        this.parser = parser;
        this.composedJobParser = new JobParser();
    }

    @Override
    public D save(D definition) {
        List<ModuleDescriptor> moduleDescriptors;
        List<ModuleDefinition> moduleDefinitions;
        Assert.notNull(definition, (String)"Definition may not be null");
        String name = ((BaseDefinition)definition).getName();
        String def = ((BaseDefinition)definition).getDefinition();
        this.validateBeforeSave(name, def);
        if (!ComposedJobUtil.isComposedJobDefinition(def) && !(moduleDefinitions = this.createModuleDefinitions(moduleDescriptors = this.parser.parse(name, def, this.definitionKind))).isEmpty()) {
            ((BaseDefinition)definition).setModuleDefinitions(moduleDefinitions);
        }
        BaseDefinition savedDefinition = (BaseDefinition)this.repository.save(definition);
        return (D)this.afterSave(savedDefinition);
    }

    @Override
    public void validateBeforeSave(String name, String definition) {
        Assert.hasText((String)name, (String)"name cannot be blank or null");
        BaseDefinition definitionFromRepo = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (definitionFromRepo != null) {
            this.throwDefinitionAlreadyExistsException(definitionFromRepo);
        }
        Assert.hasText((String)definition, (String)"definition cannot be blank or null");
        if (!ComposedJobUtil.isComposedJobDefinition(definition)) {
            this.parser.parse(name, definition, this.definitionKind);
        } else {
            this.composedJobParser.parse(definition);
        }
    }

    protected List<ModuleDefinition> createModuleDefinitions(List<ModuleDescriptor> moduleDescriptors) {
        ArrayList<ModuleDefinition> moduleDefinitions = new ArrayList<ModuleDefinition>(moduleDescriptors.size());
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            moduleDefinitions.add(moduleDescriptor.getModuleDefinition());
        }
        return moduleDefinitions;
    }

    protected ZooKeeperConnection getZooKeeperConnection() {
        return this.zkConnection;
    }

    protected D afterSave(D savedDefinition) {
        return savedDefinition;
    }

    protected void throwDefinitionAlreadyExistsException(D definition) {
        throw new DefinitionAlreadyExistsException(((BaseDefinition)definition).getName(), String.format("There is already a %s named '%%s'", new Object[]{this.definitionKind}));
    }

    protected void throwNoSuchDefinitionException(String name) {
        throw new NoSuchDefinitionException(name, String.format("There is no %s definition named '%%s'", new Object[]{this.definitionKind}));
    }

    protected void throwDefinitionNotDeployable(String name) {
        throw new NoSuchDefinitionException(name, String.format("The %s named '%%s' cannot be deployed", new Object[]{this.definitionKind}));
    }

    protected void throwNoSuchDefinitionException(String name, String definitionKind) {
        throw new NoSuchDefinitionException(name, String.format("There is no %s definition named '%%s'", definitionKind));
    }

    protected void throwNotDeployedException(String name) {
        throw new NotDeployedException(name, String.format("The %s named '%%s' is not currently deployed", new Object[]{this.definitionKind}));
    }

    protected void throwAlreadyDeployedException(String name) {
        throw new AlreadyDeployedException(name, String.format("The %s named '%%s' is already deployed", new Object[]{this.definitionKind}));
    }

    @Override
    public D findOne(String name) {
        return (D)((BaseDefinition)this.repository.findOne((Serializable)((Object)name)));
    }

    @Override
    public Iterable<D> findAll() {
        return this.repository.findAll();
    }

    @Override
    public Page<D> findAll(Pageable pageable) {
        return this.repository.findAll(pageable);
    }

    @Override
    public void deleteAll() {
        for (BaseDefinition d : this.findAll()) {
            this.delete(d.getName());
        }
    }

    protected CrudRepository<D, String> getDefinitionRepository() {
        return this.repository;
    }

    protected D basicDeploy(String name, Map<String, String> properties) {
        Assert.hasText((String)name, (String)"name cannot be blank or null");
        logger.trace("Deploying {}", (Object)name);
        BaseDefinition definition = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (definition == null) {
            this.throwNoSuchDefinitionException(name);
        }
        this.validateDeploymentProperties(definition, properties);
        try {
            String deploymentPath = this.getDeploymentPath(definition);
            String statusPath = Paths.build(deploymentPath, "status");
            byte[] propertyBytes = DeploymentPropertiesFormat.formatDeploymentProperties(properties).getBytes("UTF-8");
            byte[] statusBytes = ZooKeeperUtils.mapToBytes(new DeploymentUnitStatus(DeploymentUnitStatus.State.deploying).toMap());
            ((CuratorTransactionBridge)((ACLPathAndBytesable)((CuratorTransactionBridge)this.zkConnection.getClient().inTransaction().create().forPath(deploymentPath, propertyBytes)).and().create().withMode(CreateMode.EPHEMERAL)).forPath(statusPath, statusBytes)).and().commit();
        }
        catch (KeeperException.NodeExistsException e) {
            this.throwAlreadyDeployedException(name);
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return (D)definition;
    }

    private void validateDeploymentProperties(D definition, Map<String, String> properties) {
        List<Object> modules = null;
        if (!ComposedJobUtil.isComposedJobDefinition(((BaseDefinition)definition).getDefinition())) {
            modules = this.parser.parse(((BaseDefinition)definition).getName(), ((BaseDefinition)definition).getDefinition(), this.definitionKind);
        } else {
            modules = new ArrayList();
            ModuleDescriptor.Builder builder = new ModuleDescriptor.Builder().setType(ModuleType.job).setGroup("job").setModuleName(ComposedJobUtil.getComposedJobModuleName(((BaseDefinition)definition).getName())).setModuleLabel("").setIndex(0);
            modules.add(builder.build());
        }
        HashSet<String> moduleLabels = new HashSet<String>(modules.size());
        for (ModuleDescriptor moduleDescriptor : modules) {
            moduleLabels.add(moduleDescriptor.getModuleLabel());
        }
        for (Map.Entry entry : properties.entrySet()) {
            Matcher matcher = DEPLOYMENT_PROPERTY_PATTERN.matcher((CharSequence)entry.getKey());
            Assert.isTrue((boolean)matcher.matches(), (String)String.format("'%s' does not match '%s'", entry.getKey(), DEPLOYMENT_PROPERTY_PATTERN));
            String moduleName = matcher.group(1);
            Assert.isTrue(("*".equals(moduleName) || moduleLabels.contains(moduleName) ? 1 : 0) != 0, (String)String.format("'%s' refers to a module that is not in the list: %s", entry.getKey(), moduleLabels));
        }
    }

    protected abstract D createDefinition(String var1, String var2);

    protected abstract String getDeploymentPath(D var1);

    @Override
    public void validateBeforeDelete(String name) {
        BaseDefinition def = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (def == null) {
            this.throwNoSuchDefinitionException(name);
        }
    }

    @Override
    public void delete(String name) {
        BaseDefinition def = (BaseDefinition)this.getDefinitionRepository().findOne((Serializable)((Object)name));
        if (def == null) {
            this.throwNoSuchDefinitionException(name);
        }
        this.beforeDelete(def);
        this.getDefinitionRepository().delete((Object)def);
    }

    protected void beforeDelete(D definition) {
    }
}

