/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.spark;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.ContainerFilter;
import org.springframework.xd.dirt.module.store.ModuleMetadata;
import org.springframework.xd.dirt.module.store.ModuleMetadataRepository;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;

public class SparkStreamingContainerFilter
implements ContainerFilter {
    @Autowired
    private ModuleMetadataRepository moduleMetadataRepository;
    @Autowired
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;

    @Override
    public List<Container> filterContainers(ModuleDescriptor moduleDescriptor, Iterable<Container> availableContainers) {
        ModuleOptionsMetadata optionsMetadata = this.moduleOptionsMetadataResolver.resolve(moduleDescriptor.getModuleDefinition());
        ArrayList containersForDeployment = Lists.newArrayList(availableContainers);
        try {
            ModuleOptions options = optionsMetadata.interpolate(moduleDescriptor.getParameters());
            String name = (String)options.asPropertySource().getProperty("moduleExecutionFramework");
            if ("spark".equals(name)) {
                Iterable deployedModules = this.moduleMetadataRepository.findAll();
                ArrayList<ModuleMetadata> sparkModules = new ArrayList<ModuleMetadata>();
                for (ModuleMetadata moduleMetadata : deployedModules) {
                    String moduleExecutionFramework = moduleMetadata.getModuleOptions().getProperty("moduleExecutionFramework");
                    if (moduleExecutionFramework == null || !moduleExecutionFramework.equals("spark")) continue;
                    sparkModules.add(moduleMetadata);
                }
                for (Container container : availableContainers) {
                    for (ModuleMetadata sparkModule : sparkModules) {
                        if (!sparkModule.getContainerId().equals(container.getName())) continue;
                        containersForDeployment.remove(container);
                    }
                }
            }
        }
        catch (BindException be) {
            throw new RuntimeException(be);
        }
        return containersForDeployment;
    }
}

