/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.singlenode;

import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.container.decryptor.DecryptorContext;
import org.springframework.xd.dirt.server.ApplicationUtils;
import org.springframework.xd.dirt.server.MessageBusClassLoaderFactory;
import org.springframework.xd.dirt.server.ParentConfiguration;
import org.springframework.xd.dirt.server.SharedServerContextConfiguration;
import org.springframework.xd.dirt.server.admin.AdminServerApplication;
import org.springframework.xd.dirt.server.container.ContainerBootstrapContext;
import org.springframework.xd.dirt.server.container.ContainerConfiguration;
import org.springframework.xd.dirt.server.container.ContainerServerApplication;
import org.springframework.xd.dirt.server.options.SingleNodeOptions;
import org.springframework.xd.dirt.util.BannerUtils;

public class SingleNodeApplication {
    private ConfigurableApplicationContext adminContext;
    private ConfigurableApplicationContext pluginContext;
    private ConfigurableApplicationContext containerContext;

    public static void main(String[] args) {
        new SingleNodeApplication().run(args);
    }

    public SingleNodeApplication run(String ... args) {
        System.out.println(BannerUtils.displayBanner(this.getClass().getSimpleName(), null));
        ContainerBootstrapContext bootstrapContext = new ContainerBootstrapContext(new SingleNodeOptions());
        MessageBusClassLoaderFactory classLoaderFactory = new MessageBusClassLoaderFactory();
        DecryptorContext decryptorContext = new DecryptorContext();
        SpringApplicationBuilder admin = new SpringApplicationBuilder(new Object[]{SingleNodeOptions.class, ParentConfiguration.class}).logStartupInfo(false).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{classLoaderFactory}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).profiles(new String[]{"admin", "singlenode"}).initializers(new ApplicationContextInitializer[]{new HsqldbServerProfileActivator()}).child(new Object[]{SharedServerContextConfiguration.class, SingleNodeOptions.class}).resourceLoader((ResourceLoader)classLoaderFactory.getResolver()).logStartupInfo(false).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).child(new Object[]{SingleNodeOptions.class, AdminServerApplication.class}).main(AdminServerApplication.class).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()});
        admin.showBanner(false);
        admin.run(args);
        SpringApplicationBuilder container = admin.sibling(new Object[]{SingleNodeOptions.class, ContainerServerApplication.class}).logStartupInfo(false).profiles(new String[]{"container", "singlenode"}).listeners(ApplicationUtils.mergeApplicationListeners(bootstrapContext.commandLineListener(), bootstrapContext.pluginContextInitializers())).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).child(new Object[]{ContainerConfiguration.class}).main(ContainerServerApplication.class).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).web(false);
        container.showBanner(false);
        container.run(args);
        this.adminContext = admin.context();
        this.containerContext = container.context();
        this.pluginContext = (ConfigurableApplicationContext)this.containerContext.getParent();
        return this;
    }

    public void close() {
        this.close(this.containerContext);
        this.close(this.pluginContext);
        this.close(this.adminContext);
    }

    private void close(ConfigurableApplicationContext context) {
        if (context != null) {
            context.close();
            ApplicationContext parent = context.getParent();
            if (parent instanceof ConfigurableApplicationContext) {
                this.close((ConfigurableApplicationContext)parent);
            }
        }
    }

    public ConfigurableApplicationContext adminContext() {
        return this.adminContext;
    }

    public ConfigurableApplicationContext pluginContext() {
        return this.pluginContext;
    }

    public ConfigurableApplicationContext containerContext() {
        return this.containerContext;
    }

    class HsqldbServerProfileActivator
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private static final String SPRING_DATASOURCE_URL_OPTION = "${spring.datasource.url}";
        private static final String SINGLENODE_EMBEDDED_HSQL = "${embeddedHsql}";

        HsqldbServerProfileActivator() {
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            String dataSourceUrl = applicationContext.getEnvironment().resolvePlaceholders(SPRING_DATASOURCE_URL_OPTION);
            String embeddedHsql = applicationContext.getEnvironment().resolvePlaceholders(SINGLENODE_EMBEDDED_HSQL);
            Assert.notNull((Object)dataSourceUrl, (String)"At least one datasource (for batch) must be set.");
            Assert.notNull((Object)embeddedHsql, (String)"The property singlenode.embeddedHsql must be set for singlenode. Default is true.");
            if (dataSourceUrl.contains("hsql") && embeddedHsql.equals("true")) {
                applicationContext.getEnvironment().addActiveProfile("hsqldbServer");
            }
        }
    }
}

