/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.security;

import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.ldap.LdapAuthenticationProviderConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="xd.security.authentication.ldap")
@ConditionalOnProperty(value={"xd.security.authentication.ldap.enabled"})
public class LdapAuthenticationConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private String url;
    private String userDnPattern;
    private String managerDn;
    private String managerPassword;
    private String userSearchBase = "";
    private String userSearchFilter;
    private String groupSearchFilter = "";
    private String groupSearchBase = "";
    private String groupRoleAttribute = "cn";

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserDnPattern() {
        return this.userDnPattern;
    }

    public void setUserDnPattern(String userDnPattern) {
        this.userDnPattern = userDnPattern;
    }

    public String getManagerDn() {
        return this.managerDn;
    }

    public void setManagerDn(String managerDn) {
        this.managerDn = managerDn;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public String getGroupRoleAttribute() {
        return this.groupRoleAttribute;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        LdapAuthenticationProviderConfigurer ldapConfigurer = auth.ldapAuthentication();
        Assert.hasText((String)this.url, (String)"'url' must not be empty");
        Assert.isTrue((boolean)(StringUtils.isEmpty((Object)this.userDnPattern) ^ StringUtils.isEmpty((Object)this.userSearchFilter)), (String)"exactly one of 'userDnPattern' or 'userSearch' must be provided");
        ldapConfigurer.contextSource().url(this.url).managerDn(this.managerDn).managerPassword(this.managerPassword);
        if (!StringUtils.isEmpty((Object)this.userDnPattern)) {
            ldapConfigurer.userDnPatterns(new String[]{this.userDnPattern});
        }
        if (!StringUtils.isEmpty((Object)this.userSearchFilter)) {
            ldapConfigurer.userSearchBase(this.userSearchBase).userSearchFilter(this.userSearchFilter);
        }
        if (!StringUtils.isEmpty((Object)this.groupSearchFilter)) {
            ldapConfigurer.groupSearchBase(this.groupSearchBase).groupSearchFilter(this.groupSearchFilter).groupRoleAttribute(this.groupRoleAttribute);
        } else {
            ldapConfigurer.ldapAuthoritiesPopulator(new LdapAuthoritiesPopulator(){

                public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
                    return Collections.singleton(new SimpleGrantedAuthority("ROLE_ADMIN"));
                }
            });
        }
    }
}

