/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.security;

import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;

@Configuration
@ConditionalOnProperty(value={"xd.security.authentication.file.enabled"})
@ConfigurationProperties(prefix="xd.security.authentication.file")
public class FileAuthenticationConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private Properties users;

    public void setUsers(Properties users) {
        this.users = users;
    }

    public Properties getUsers() {
        return this.users;
    }

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        InMemoryUserDetailsManager inMemory = new InMemoryUserDetailsManager(this.getUsers());
        auth.userDetailsService((UserDetailsService)inMemory);
    }
}

