/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.options;

import java.io.IOException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Setter;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.server.options.CommandLinePropertySourceOverridingListener;
import org.springframework.xd.dirt.server.options.ResourcePatternScanningOptionHandler;

public final class ResourcePatternScanningOptionHandlers {
    private static final String CONFIGURATION_ROOT = "classpath*:/META-INF/spring-xd/";

    private ResourcePatternScanningOptionHandlers() {
    }

    public static class HadoopDistroOptionHandler
    extends ResourcePatternScanningOptionHandler {
        public HadoopDistroOptionHandler(CmdLineParser parser, OptionDef option, Setter<String> setter) throws IOException {
            super(parser, option, setter, HadoopDistroOptionHandler.resolveXDHome());
            this.exclude("messagebus");
        }

        private static String resolveXDHome() {
            Assert.state((CommandLinePropertySourceOverridingListener.getCurrentEnvironment() != null ? 1 : 0) != 0, (String)("Expected to be called in the control flow of " + CommandLinePropertySourceOverridingListener.class.getSimpleName() + ".onApplicationEvent()"));
            String resolved = CommandLinePropertySourceOverridingListener.getCurrentEnvironment().resolvePlaceholders("${xd.home:.}/lib/*");
            resolved = StringUtils.cleanPath((String)resolved).replace("//", "/");
            return "file:" + resolved;
        }

        @Override
        protected boolean shouldConsider(Resource r) {
            try {
                return r.getFile().isDirectory();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static class DistributedAnalyticsOptionHandler
    extends ResourcePatternScanningOptionHandler {
        public DistributedAnalyticsOptionHandler(CmdLineParser parser, OptionDef option, Setter<String> setter) throws IOException {
            super(parser, option, setter, "classpath*:/META-INF/spring-xd/analytics/*-analytics.xml");
            this.exclude("memory");
        }
    }

    public static class SingleNodeAnalyticsOptionHandler
    extends ResourcePatternScanningOptionHandler {
        public SingleNodeAnalyticsOptionHandler(CmdLineParser parser, OptionDef option, Setter<String> setter) throws IOException {
            super(parser, option, setter, "classpath*:/META-INF/spring-xd/analytics/*-analytics.xml");
        }
    }

    public static class SingleNodeDataTransportOptionHandler
    extends ResourcePatternScanningOptionHandler {
        public SingleNodeDataTransportOptionHandler(CmdLineParser parser, OptionDef option, Setter<String> setter) throws IOException {
            super(parser, option, setter, SingleNodeDataTransportOptionHandler.resolveMessageBusPath());
            this.possibleValues.add("local");
        }

        private static String resolveMessageBusPath() {
            String xdHome = CommandLinePropertySourceOverridingListener.getCurrentEnvironment().resolvePlaceholders("${XD_HOME}");
            return "file:" + xdHome.replaceAll("\\\\", "/") + "/lib/messagebus/*";
        }

        @Override
        protected boolean shouldConsider(Resource r) {
            try {
                return r.getFile().isDirectory();
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

