/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.options;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.xd.dirt.server.options.CommandLinePropertySourceOverridingListener;

public abstract class ResourcePatternScanningOptionHandler
extends OptionHandler<String> {
    protected final Set<String> possibleValues = new HashSet<String>();
    private final Set<String> excluded = new HashSet<String>();

    protected ResourcePatternScanningOptionHandler(CmdLineParser parser, OptionDef option, Setter<String> setter, String glob) throws IOException {
        super(parser, option, setter);
        this.init(glob, new String[0]);
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        String s = params.getParameter(0);
        if (!this.possibleValues.contains(s)) {
            String errorMessage = String.format("'%s' is not a valid value. Possible values are %s", s, this.possibleValues);
            if (this.option instanceof NamedOptionDef) {
                NamedOptionDef named = (NamedOptionDef)this.option;
                errorMessage = String.format("'%s' is not a valid value for option %s. Possible values are %s", s, named.name(), this.possibleValues);
            }
            if (this.excluded.contains(s)) {
                errorMessage = errorMessage + String.format(". Note that '%s' has been explicitly excluded from the list of possible values, even though a resource with that name exists", s);
            }
            throw new CmdLineException(this.owner, errorMessage);
        }
        this.setter.addValue((Object)s);
        return 1;
    }

    public String getDefaultMetaVariable() {
        return this.possibleValues.toString().replace(",", " |");
    }

    private void init(String glob, String ... excludes) throws IOException {
        String resolved = CommandLinePropertySourceOverridingListener.getCurrentEnvironment().resolvePlaceholders(glob);
        int protocolColon = resolved.indexOf(58);
        String withoutProtocol = protocolColon != -1 ? resolved.substring(protocolColon + 1) : resolved;
        Pattern capturing = Pattern.compile(".*" + withoutProtocol.replace("*", "([^/]*)") + ".*");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource r : resolver.getResources(resolved)) {
            if (!this.shouldConsider(r)) continue;
            String path = r.getURL().toString();
            Matcher matcher = capturing.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Expected to match '%s' with regex '%s'", path, capturing));
            }
            this.possibleValues.add(matcher.group(1));
        }
    }

    protected boolean shouldConsider(Resource r) {
        return true;
    }

    protected void exclude(String ... excludes) {
        this.excluded.addAll(Arrays.asList(excludes));
        this.possibleValues.removeAll(this.excluded);
    }

    protected void include(String ... includes) {
        this.possibleValues.addAll(Arrays.asList(includes));
    }
}

