/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.options;

import org.kohsuke.args4j.Option;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.xd.dirt.server.options.ResourcePatternScanningOptionHandlers;

@ConfigurationProperties
public class CommonOptions {
    @Option(name="--help", usage="Show this help screen", aliases={"-?", "-h"})
    private boolean showHelp = false;
    @Option(name="--verbose", usage="Display all configuration properties", aliases={"-v"})
    private boolean verbose = false;
    @Option(name="--mgmtPort", usage="The port for the management server", metaVar="<mgmtPort>")
    private Integer mgmtPort;
    static final String DEFAULT_HADOOP_DISTRO = "hadoop27";
    @Option(name="--hadoopDistro", handler=ResourcePatternScanningOptionHandlers.HadoopDistroOptionHandler.class, usage="The Hadoop distribution to be used for HDFS access")
    private String distro = "hadoop27";

    public Boolean isShowHelp() {
        return this.showHelp ? Boolean.valueOf(true) : null;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Integer getXD_MGMT_PORT() {
        return this.mgmtPort;
    }

    public void setXD_MGMT_PORT(int mgmtPort) {
        this.mgmtPort = mgmtPort;
    }

    public void setHADOOP_DISTRO(String distro) {
        this.distro = distro;
    }

    public String getHADOOP_DISTRO() {
        return this.distro;
    }
}

