/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.options;

import java.io.OutputStream;
import java.util.HashMap;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.xd.dirt.server.options.BeanPropertiesPropertySource;
import org.springframework.xd.dirt.server.options.CommonOptions;

public class CommandLinePropertySourceOverridingListener<T extends CommonOptions>
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private T options;
    private static ThreadLocal<Environment> environmentHolder = new ThreadLocal();

    public CommandLinePropertySourceOverridingListener(T options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (event.getArgs().length == 0 && event.getEnvironment().getPropertySources().get("commandLineArgs") == null) {
            event.getEnvironment().getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource(new String[0]));
        }
        CmdLineParser parser = null;
        try {
            environmentHolder.set((Environment)event.getEnvironment());
            parser = new CmdLineParser(this.options);
            parser.parseArgument(event.getArgs());
            if (Boolean.TRUE.equals(((CommonOptions)this.options).isShowHelp())) {
                System.err.println("Usage:");
                parser.printUsage((OutputStream)System.err);
                System.exit(0);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Usage:");
            parser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        finally {
            environmentHolder.set(null);
        }
        BeanPropertiesPropertySource<T> ps = new BeanPropertiesPropertySource<T>("commandLineArgs", this.options);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : ps.getPropertyNames()) {
            Object raw = ps.getProperty(key);
            if (raw == null) continue;
            map.put(key, raw.toString());
        }
        event.getEnvironment().getPropertySources().replace("commandLineArgs", (PropertySource)new MapPropertySource("commandLineArgs", map));
    }

    static Environment getCurrentEnvironment() {
        return environmentHolder.get();
    }
}

