/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.options;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.env.EnumerablePropertySource;

public class BeanPropertiesPropertySource<T>
extends EnumerablePropertySource<T> {
    private final BeanWrapper beanWrapper;

    public BeanPropertiesPropertySource(String name, T source) {
        super(name, source);
        this.beanWrapper = new BeanWrapperImpl(source);
    }

    public String[] getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyDescriptor pd : this.beanWrapper.getPropertyDescriptors()) {
            String name = pd.getName();
            if (!this.beanWrapper.isReadableProperty(name) || "class".equals(name)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object getProperty(String name) {
        if (Arrays.asList(this.getPropertyNames()).contains(name)) {
            return this.beanWrapper.getPropertyValue(name);
        }
        return null;
    }
}

