/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.container;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.AuditAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.xd.dirt.cluster.ContainerAttributes;
import org.springframework.xd.dirt.container.decryptor.DecryptorContext;
import org.springframework.xd.dirt.server.ApplicationUtils;
import org.springframework.xd.dirt.server.MessageBusClassLoaderFactory;
import org.springframework.xd.dirt.server.ParentConfiguration;
import org.springframework.xd.dirt.server.SharedServerContextConfiguration;
import org.springframework.xd.dirt.server.container.ContainerBootstrapContext;
import org.springframework.xd.dirt.server.container.ContainerConfiguration;
import org.springframework.xd.dirt.server.options.ContainerOptions;
import org.springframework.xd.dirt.util.BannerUtils;
import org.springframework.xd.dirt.util.RuntimeUtils;

@Configuration
@EnableAutoConfiguration(exclude={BatchAutoConfiguration.class, JmxAutoConfiguration.class, AuditAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, SolrAutoConfiguration.class})
public class ContainerServerApplication
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerServerApplication.class);
    public static final String CONTAINER_ATTRIBUTES_PREFIX = "xd.container.";
    private ConfigurableApplicationContext containerContext;
    private ConfigurableEnvironment environment;

    public static void main(String[] args) {
        new ContainerServerApplication().run(args);
    }

    public void dumpContextConfiguration() {
        ApplicationUtils.dumpContainerApplicationContextConfiguration((ApplicationContext)this.containerContext);
    }

    public ContainerServerApplication run(String ... args) {
        System.out.println(BannerUtils.displayBanner(this.getClass().getSimpleName(), null));
        try {
            ContainerBootstrapContext bootstrapContext = new ContainerBootstrapContext(new ContainerOptions());
            MessageBusClassLoaderFactory classLoaderFactory = new MessageBusClassLoaderFactory();
            DecryptorContext decryptorContext = new DecryptorContext();
            this.containerContext = new SpringApplicationBuilder(new Object[]{ContainerOptions.class, ParentConfiguration.class}).logStartupInfo(false).profiles(new String[]{"container"}).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{classLoaderFactory}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).child(new Object[]{SharedServerContextConfiguration.class, ContainerOptions.class}).resourceLoader((ResourceLoader)classLoaderFactory.getResolver()).logStartupInfo(false).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).child(new Object[]{ContainerServerApplication.class}).logStartupInfo(false).listeners(ApplicationUtils.mergeApplicationListeners(bootstrapContext.commandLineListener(), bootstrapContext.pluginContextInitializers())).child(new Object[]{ContainerConfiguration.class}).listeners(new ApplicationListener[]{bootstrapContext.commandLineListener()}).listeners(new ApplicationListener[]{decryptorContext.propertiesDecryptor()}).initializers(new ApplicationContextInitializer[]{new IdInitializer()}).showBanner(false).run(args);
        }
        catch (Exception e) {
            this.handleFieldErrors(e);
        }
        return this;
    }

    @Bean
    public ContainerAttributes containerAttributes() {
        ContainerAttributes containerAttributes = new ContainerAttributes();
        this.setConfiguredContainerAttributes(containerAttributes);
        String containerIp = this.environment.getProperty("xd.container.ip");
        String containerHostname = this.environment.getProperty("xd.container.host");
        containerAttributes.setIp(StringUtils.hasText((String)containerIp) ? containerIp : RuntimeUtils.getIpAddress());
        containerAttributes.setHost(StringUtils.hasText((String)containerHostname) ? containerHostname : RuntimeUtils.getHost());
        containerAttributes.setPid(RuntimeUtils.getPid());
        return containerAttributes;
    }

    private void setConfiguredContainerAttributes(ContainerAttributes containerAttributes) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource ps = (EnumerablePropertySource)propertySource;
            for (String key : ps.getPropertyNames()) {
                if (!key.startsWith(CONTAINER_ATTRIBUTES_PREFIX)) continue;
                String attributeKey = key.replaceAll(CONTAINER_ATTRIBUTES_PREFIX, "");
                attributes.put(attributeKey, this.environment.getProperty(key));
            }
        }
        containerAttributes.putAll((Map<? extends String, ? extends String>)attributes);
    }

    public void setEnvironment(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)("unsupported environment type. " + environment.getClass()));
        this.environment = (ConfigurableEnvironment)environment;
    }

    private void handleFieldErrors(Exception e) {
        if (e.getCause() instanceof BindException) {
            BindException be = (BindException)e.getCause();
            for (FieldError error : be.getFieldErrors()) {
                logger.error(String.format("the value '%s' is not allowed for property '%s'", error.getRejectedValue(), error.getField()));
            }
        } else {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static class IdInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private IdInitializer() {
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            ContainerAttributes containerAttributes = (ContainerAttributes)applicationContext.getParent().getBean(ContainerAttributes.class);
            applicationContext.setId(containerAttributes.getId());
        }
    }
}

