/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.container;

import java.io.Serializable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.ContainerAttributes;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.server.container.DeploymentListener;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnectionListener;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ContainerRegistrar
implements ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRegistrar.class);
    private final ContainerAttributes containerAttributes;
    private volatile PathChildrenCache deployments;
    private final ContainerRepository containerRepository;
    private final ZooKeeperConnection zkConnection;
    private volatile ApplicationContext context;
    private final DeploymentListener deploymentListener;
    private static final String MGMT_CONTEXT_NAMESPACE = "management";

    public ContainerRegistrar(ZooKeeperConnection zkConnection, ContainerAttributes containerAttributes, ContainerRepository containerRepository, DeploymentListener deploymentListener) {
        this.zkConnection = zkConnection;
        this.containerAttributes = containerAttributes;
        this.containerRepository = containerRepository;
        this.deploymentListener = deploymentListener;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        String namespace;
        if (event instanceof ContextRefreshedEvent) {
            if (this.context.equals(((ContextRefreshedEvent)event).getApplicationContext())) {
                if (this.zkConnection.isConnected()) {
                    this.registerWithZooKeeper(this.zkConnection.getClient());
                }
                this.zkConnection.addListener(new ContainerConnectionListener());
            }
        } else if (event instanceof EmbeddedServletContainerInitializedEvent && MGMT_CONTEXT_NAMESPACE.equals(namespace = ((EmbeddedServletContainerInitializedEvent)event).getApplicationContext().getNamespace())) {
            int managementPort = ((EmbeddedServletContainerInitializedEvent)event).getEmbeddedServletContainer().getPort();
            ContainerAttributes containerAttributes = this.containerAttributes;
            synchronized (containerAttributes) {
                this.containerAttributes.setManagementPort(String.valueOf(managementPort));
                String containerId = this.containerAttributes.getId();
                if (this.zkConnection.isConnected() && this.containerRepository.exists((Serializable)((Object)containerId))) {
                    this.containerRepository.update(new Container(containerId, this.containerAttributes));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithZooKeeper(CuratorFramework client) {
        try {
            String containerId = this.containerAttributes.getId();
            String containerPath = Paths.build("containers", containerId);
            Stat containerPathStat = (Stat)client.checkExists().forPath(containerPath);
            if (containerPathStat != null) {
                long currSession;
                long prevSession = containerPathStat.getEphemeralOwner();
                if (prevSession == (currSession = client.getZookeeperClient().getZooKeeper().getSessionId())) {
                    logger.info(String.format("Existing registration for container %s with session 0x%x detected", containerId, currSession));
                    return;
                }
                logger.info(String.format("Previous registration for container %s with session %x detected; current session: 0x%x", containerId, prevSession, currSession));
                int i2 = 1;
                long startTime = System.currentTimeMillis();
                while (client.checkExists().forPath(containerPath) != null) {
                    logger.info("Waiting for container registration cleanup (elapsed time {} seconds)...", (Object)((System.currentTimeMillis() - startTime) / 1000L));
                    Thread.sleep(this.exponentialDelay(i2++, 60L) * 1000L);
                }
            }
            String moduleDeploymentPath = Paths.build("deployments/modules", "allocated", containerId);
            int i = 1;
            long startTime = System.currentTimeMillis();
            while (client.checkExists().forPath(moduleDeploymentPath) != null) {
                logger.info("Waiting for supervisor to clean up prior deployments (elapsed time {} seconds)...", (Object)((System.currentTimeMillis() - startTime) / 1000L));
                Thread.sleep(this.exponentialDelay(i++, 60L) * 1000L);
            }
            client.create().creatingParentsIfNeeded().forPath(moduleDeploymentPath);
            ContainerAttributes i2 = this.containerAttributes;
            synchronized (i2) {
                this.containerRepository.save(new Container(containerId, this.containerAttributes));
            }
            if (this.deployments != null) {
                try {
                    this.deployments.close();
                }
                catch (Exception e) {
                    logger.trace("Exception while closing deployments cache", (Throwable)e);
                }
            }
            this.deployments = new PathChildrenCache(client, moduleDeploymentPath, true, ThreadUtils.newThreadFactory((String)"DeploymentsPathChildrenCache"));
            this.deployments.getListenable().addListener((Object)this.deploymentListener);
            this.deployments.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            logger.info("Container {} joined cluster", (Object)this.containerAttributes);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    private long exponentialDelay(int attempts, long max) {
        long delay = ((long)Math.pow(2.0, attempts) - 1L) / 2L;
        return Math.min(delay, max);
    }

    private class ContainerConnectionListener
    implements ZooKeeperConnectionListener {
        private ConnectionState lastKnownState;

        private ContainerConnectionListener() {
        }

        @Override
        public void onConnect(CuratorFramework client) {
            this.lastKnownState = ConnectionState.CONNECTED;
            ContainerRegistrar.this.registerWithZooKeeper(client);
        }

        @Override
        public void onResume(CuratorFramework client) {
            if (this.lastKnownState == ConnectionState.LOST) {
                if (client.getState() == CuratorFrameworkState.STARTED) {
                    logger.info("ZooKeeper connection lost and restarted; registering container");
                    ContainerRegistrar.this.registerWithZooKeeper(client);
                } else {
                    logger.info("ZooKeeper connection lost; restarting connection");
                    ContainerRegistrar.this.zkConnection.stop();
                    ContainerRegistrar.this.zkConnection.start();
                }
            } else if (this.lastKnownState == ConnectionState.SUSPENDED) {
                logger.info("ZooKeeper connection resumed");
                ContainerRegistrar.this.registerWithZooKeeper(client);
            }
            this.lastKnownState = ConnectionState.RECONNECTED;
        }

        @Override
        public void onDisconnect(CuratorFramework client) {
            logger.warn("ZooKeeper connection terminated: {}", (Object)ContainerRegistrar.this.containerAttributes.getId());
            this.lastKnownState = ConnectionState.LOST;
            try {
                ContainerRegistrar.this.deployments.getListenable().removeListener((Object)ContainerRegistrar.this.deploymentListener);
                ContainerRegistrar.this.deployments.close();
            }
            catch (Exception e) {
                logger.debug("Exception closing deployments cache", (Throwable)e);
            }
            ContainerRegistrar.this.deploymentListener.undeployAllModules();
        }

        @Override
        public void onSuspend(CuratorFramework client) {
            this.lastKnownState = ConnectionState.SUSPENDED;
            logger.info("ZooKeeper connection suspended: {}", (Object)ContainerRegistrar.this.containerAttributes.getId());
        }
    }
}

