/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.container;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.AuditAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SourceFilteringListener;
import org.springframework.xd.dirt.cluster.ContainerAttributes;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.module.ModuleDeployer;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.server.container.ContainerRegistrar;
import org.springframework.xd.dirt.server.container.DeploymentListener;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xd.dirt.stream.StreamDefinitionRepository;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.util.XdConfigLoggingInitializer;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnectionConfigurer;
import org.springframework.xd.module.core.ModuleFactory;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;

@Configuration
@EnableAutoConfiguration(exclude={BatchAutoConfiguration.class, JmxAutoConfiguration.class, AuditAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, SolrAutoConfiguration.class})
public class ContainerConfiguration {
    @Autowired(required=false)
    ZooKeeperConnectionConfigurer zooKeeperConnectionConfigurer;
    @Autowired
    private ContainerAttributes containerAttributes;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private StreamDefinitionRepository streamDefinitionRepository;
    @Autowired
    private JobDefinitionRepository jobDefinitionRepository;
    @Autowired
    private ModuleRegistry moduleRegistry;
    @Autowired
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;
    @Autowired
    private ModuleDeployer moduleDeployer;
    @Autowired
    private ZooKeeperConnection zooKeeperConnection;

    @Bean
    public ApplicationListener<?> xdInitializer(ApplicationContext context) {
        XdConfigLoggingInitializer delegate = new XdConfigLoggingInitializer(true);
        delegate.setEnvironment(context.getEnvironment());
        delegate.setContainerAttributes(this.containerAttributes);
        return new SourceFilteringListener((Object)context, (ApplicationListener)delegate);
    }

    @Bean
    public ModuleFactory moduleFactory() {
        return new ModuleFactory(this.moduleOptionsMetadataResolver);
    }

    @Bean
    public ModuleDeployer moduleDeployer() {
        return new ModuleDeployer(this.moduleFactory());
    }

    @Bean
    public ContainerRegistrar containerRegistrar() {
        this.initializeZooKeeperConnection();
        return new ContainerRegistrar(this.zooKeeperConnection, this.containerAttributes, this.containerRepository, this.deploymentListener());
    }

    @Bean
    public DeploymentListener deploymentListener() {
        this.initializeZooKeeperConnection();
        StreamFactory streamFactory = new StreamFactory(this.streamDefinitionRepository, this.moduleRegistry, this.moduleOptionsMetadataResolver);
        JobFactory jobFactory = new JobFactory(this.jobDefinitionRepository, this.moduleRegistry, this.moduleOptionsMetadataResolver);
        return new DeploymentListener(this.zooKeeperConnection, this.moduleDeployer, this.containerAttributes, jobFactory, streamFactory);
    }

    private void initializeZooKeeperConnection() {
        if (this.zooKeeperConnectionConfigurer != null) {
            this.zooKeeperConnectionConfigurer.configureZooKeeperConnection(this.zooKeeperConnection);
            this.zooKeeperConnection.start();
        }
    }
}

