/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.container;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.xd.dirt.container.initializer.OrderedContextInitializer;
import org.springframework.xd.dirt.server.container.ContainerBootstrapConfiguration;
import org.springframework.xd.dirt.server.options.CommandLinePropertySourceOverridingListener;
import org.springframework.xd.dirt.server.options.CommonOptions;

public class ContainerBootstrapContext {
    private CommandLinePropertySourceOverridingListener<?> commandLineListener;
    private ApplicationListener<?>[] pluginContextInitializers;

    public <T extends CommonOptions> ContainerBootstrapContext(T options) {
        this.commandLineListener = new CommandLinePropertySourceOverridingListener<T>(options);
        ConfigurableApplicationContext bootstrapContext = new SpringApplicationBuilder(new Object[]{ContainerBootstrapConfiguration.class, options.getClass(), PropertyPlaceholderAutoConfiguration.class}).listeners(new ApplicationListener[]{this.commandLineListener}).headless(true).web(false).showBanner(false).run(new String[0]);
        Collection orderedContextInitializers = bootstrapContext.getBeansOfType(OrderedContextInitializer.class).values();
        this.pluginContextInitializers = orderedContextInitializers.toArray(new ApplicationListener[orderedContextInitializers.size()]);
        Arrays.sort(this.pluginContextInitializers, new OrderComparator());
    }

    public ApplicationListener<?>[] pluginContextInitializers() {
        return this.pluginContextInitializers;
    }

    public CommandLinePropertySourceOverridingListener<?> commandLineListener() {
        return this.commandLineListener;
    }
}

