/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.NoContainerException;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.dirt.server.admin.deployment.StreamRuntimePropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.DefaultModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentLoader;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ZKDeploymentHandler;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;

public class ZKStreamDeploymentHandler
extends ZKDeploymentHandler {
    private static final Logger logger = LoggerFactory.getLogger(ZKStreamDeploymentHandler.class);
    @Autowired
    private StreamFactory streamFactory;
    @Autowired
    private ContainerMatcher containerMatcher;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private ModuleDeploymentWriter moduleDeploymentWriter;
    @Autowired
    private DeploymentUnitStateCalculator stateCalculator;

    @Override
    public void deploy(String streamName) throws Exception {
        CuratorFramework client = this.zkConnection.getClient();
        this.deployStream(client, DeploymentLoader.loadStream(client, streamName, this.streamFactory));
    }

    private void deployStream(CuratorFramework client, Stream stream) throws InterruptedException {
        try {
            client.create().creatingParentsIfNeeded().forPath(Paths.build("deployments/streams", stream.getName(), "modules"));
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
        }
        String statusPath = Paths.build("deployments/streams", stream.getName(), "status");
        DeploymentUnitStatus deployingStatus = null;
        try {
            deployingStatus = new DeploymentUnitStatus(ZooKeeperUtils.bytesToMap((byte[])client.getData().forPath(statusPath)));
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.state((deployingStatus != null && deployingStatus.getState() == DeploymentUnitStatus.State.deploying ? 1 : 0) != 0, (String)String.format("Expected 'deploying' status for stream '%s'; current status: %s", stream.getName(), deployingStatus));
        try {
            ArrayList<ModuleDeploymentStatus> deploymentStatuses = new ArrayList<ModuleDeploymentStatus>();
            DefaultModuleDeploymentPropertiesProvider deploymentPropertiesProvider = new DefaultModuleDeploymentPropertiesProvider(stream);
            Iterator<ModuleDescriptor> descriptors = stream.getDeploymentOrderIterator();
            while (descriptors.hasNext()) {
                ModuleDescriptor descriptor = descriptors.next();
                ModuleDeploymentProperties deploymentProperties = deploymentPropertiesProvider.propertiesForDescriptor(descriptor);
                StreamRuntimePropertiesProvider partitionPropertiesProvider = new StreamRuntimePropertiesProvider(stream, deploymentPropertiesProvider);
                int moduleCount = deploymentProperties.getCount();
                if (moduleCount == 0) {
                    this.createModuleDeploymentRequestsPath(client, descriptor, partitionPropertiesProvider.propertiesForDescriptor(descriptor));
                } else {
                    for (int i = 0; i < moduleCount; ++i) {
                        this.createModuleDeploymentRequestsPath(client, descriptor, partitionPropertiesProvider.propertiesForDescriptor(descriptor));
                    }
                }
                try {
                    Collection<Container> containers = this.containerMatcher.match(descriptor, deploymentProperties, this.containerRepository.findAll());
                    StreamRuntimePropertiesProvider deploymentRuntimeProvider = new StreamRuntimePropertiesProvider(stream, deploymentPropertiesProvider);
                    deploymentStatuses.addAll(this.moduleDeploymentWriter.writeDeployment(descriptor, deploymentRuntimeProvider, containers));
                }
                catch (NoContainerException e) {
                    logger.warn("No containers available for deployment of module '{}' for stream '{}'", (Object)descriptor.getModuleLabel(), (Object)stream.getName());
                }
            }
            DeploymentUnitStatus status = this.stateCalculator.calculate(stream, deploymentPropertiesProvider, deploymentStatuses);
            logger.info("Deployment status for stream '{}': {}", (Object)stream.getName(), (Object)status);
            client.setData().forPath(statusPath, ZooKeeperUtils.mapToBytes(status.toMap()));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }
}

