/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.NoContainerException;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.dirt.server.admin.deployment.RuntimeModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.DefaultModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentLoader;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ZKDeploymentHandler;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public class ZKJobDeploymentHandler
extends ZKDeploymentHandler {
    private static final Logger logger = LoggerFactory.getLogger(ZKJobDeploymentHandler.class);
    @Autowired
    private JobFactory jobFactory;
    @Autowired
    private ContainerMatcher containerMatcher;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private ModuleDeploymentWriter moduleDeploymentWriter;
    @Autowired
    private DeploymentUnitStateCalculator stateCalculator;

    @Override
    public void deploy(String jobName) throws Exception {
        CuratorFramework client = this.zkConnection.getClient();
        this.deployJob(client, DeploymentLoader.loadJob(client, jobName, this.jobFactory));
    }

    private void deployJob(CuratorFramework client, Job job) throws InterruptedException {
        if (job != null) {
            try {
                client.create().creatingParentsIfNeeded().forPath(Paths.build("deployments/jobs", job.getName(), "modules"));
            }
            catch (Exception e) {
                ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
            }
            String statusPath = Paths.build("deployments/jobs", job.getName(), "status");
            DeploymentUnitStatus deployingStatus = null;
            try {
                deployingStatus = new DeploymentUnitStatus(ZooKeeperUtils.bytesToMap((byte[])client.getData().forPath(statusPath)));
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.state((deployingStatus != null && deployingStatus.getState() == DeploymentUnitStatus.State.deploying ? 1 : 0) != 0, (String)String.format("Expected 'deploying' status for job '%s'; current status: %s", job.getName(), deployingStatus));
            DefaultModuleDeploymentPropertiesProvider provider = new DefaultModuleDeploymentPropertiesProvider(job);
            try {
                ArrayList<ModuleDeploymentStatus> deploymentStatuses = new ArrayList<ModuleDeploymentStatus>();
                for (ModuleDescriptor descriptor : job.getModuleDescriptors()) {
                    RuntimeModuleDeploymentProperties deploymentProperties = new RuntimeModuleDeploymentProperties();
                    deploymentProperties.putAll(provider.propertiesForDescriptor(descriptor));
                    ArrayDeque<Container> matchedContainers = new ArrayDeque<Container>(this.containerMatcher.match(descriptor, (ModuleDeploymentProperties)deploymentProperties, this.containerRepository.findAll()));
                    if (deploymentProperties.getCount() == 0) {
                        deploymentProperties.setSequence(0);
                        this.createModuleDeploymentRequestsPath(client, descriptor, deploymentProperties);
                    } else {
                        for (int i = 1; i <= deploymentProperties.getCount(); ++i) {
                            deploymentProperties.setSequence(i);
                            this.createModuleDeploymentRequestsPath(client, descriptor, deploymentProperties);
                        }
                    }
                    RuntimeModuleDeploymentPropertiesProvider deploymentRuntimeProvider = new RuntimeModuleDeploymentPropertiesProvider(provider);
                    try {
                        deploymentStatuses.addAll(this.moduleDeploymentWriter.writeDeployment(descriptor, deploymentRuntimeProvider, matchedContainers));
                    }
                    catch (NoContainerException e) {
                        logger.warn("No containers available for deployment of job {}", (Object)job.getName());
                    }
                    DeploymentUnitStatus status = this.stateCalculator.calculate(job, provider, deploymentStatuses);
                    logger.info("Deployment status for job '{}': {}", (Object)job.getName(), (Object)status);
                    client.setData().forPath(statusPath, ZooKeeperUtils.mapToBytes(status.toMap()));
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw ZooKeeperUtils.wrapThrowable(e);
            }
        }
    }
}

