/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.EnumSet;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.RuntimeTimeoutException;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentException;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessage;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessagePublisher;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentQueue;
import org.springframework.xd.dirt.zookeeper.Paths;

public class ZKDeploymentMessagePublisher
implements DeploymentMessagePublisher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SUCCESS = "success";
    public static final String ERROR = "error";
    private final DeploymentQueue deploymentQueue;
    @Value(value="${xd.admin.deploymentTimeout:30000}")
    private long deploymentTimeout;

    public ZKDeploymentMessagePublisher(DeploymentQueue deploymentQueue) {
        this.deploymentQueue = deploymentQueue;
    }

    private CuratorFramework getClient() {
        return this.deploymentQueue.getClient();
    }

    private long getTimeout() {
        return this.deploymentTimeout * 3L;
    }

    @Override
    public void publish(DeploymentMessage message) {
        try {
            this.deploymentQueue.getDistributedQueue().put((Object)message);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void poll(DeploymentMessage message) {
        CuratorFramework client = this.getClient();
        String requestId = message.getRequestId();
        Assert.hasText((String)requestId, (String)"requestId for message required");
        ResultWatcher watcher = new ResultWatcher();
        String resultPath = Paths.build("deployments", "responses", requestId);
        try {
            this.logger.trace("result path: {}", (Object)resultPath);
            client.create().creatingParentsIfNeeded().forPath(resultPath);
            ((BackgroundPathable)client.getChildren().usingWatcher((CuratorWatcher)watcher)).forPath(resultPath);
            this.publish(message);
            long timeout = this.getTimeout();
            long expiry = System.currentTimeMillis() + timeout;
            ZKDeploymentMessagePublisher zKDeploymentMessagePublisher = this;
            synchronized (zKDeploymentMessagePublisher) {
                while (watcher.getState() == State.incomplete && System.currentTimeMillis() < expiry) {
                    this.wait(timeout);
                }
            }
            switch (watcher.getState()) {
                case incomplete: {
                    throw new RuntimeTimeoutException(String.format("Request %s timed out after %d ms", message, expiry));
                }
                case error: {
                    throw new DeploymentException(watcher.getErrorDesc());
                }
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                client.delete().deletingChildrenIfNeeded().forPath(resultPath);
            }
            catch (Exception e) {
                this.logger.debug("Exception while removing result path " + resultPath, (Throwable)e);
            }
        }
    }

    private class ResultWatcher
    implements CuratorWatcher {
        private State state = State.incomplete;
        private String errorDesc;

        private ResultWatcher() {
        }

        public State getState() {
            return this.state;
        }

        public String getErrorDesc() {
            return this.errorDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) throws Exception {
            ZKDeploymentMessagePublisher.this.logger.trace("Event: {}", (Object)event);
            if (EnumSet.of(Watcher.Event.KeeperState.SyncConnected, Watcher.Event.KeeperState.SaslAuthenticated, Watcher.Event.KeeperState.ConnectedReadOnly).contains(event.getState())) {
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                    List children = (List)ZKDeploymentMessagePublisher.this.getClient().getChildren().forPath(event.getPath());
                    Assert.state((children.size() == 1 ? 1 : 0) != 0);
                    ZKDeploymentMessagePublisher zKDeploymentMessagePublisher = ZKDeploymentMessagePublisher.this;
                    synchronized (zKDeploymentMessagePublisher) {
                        if (children.contains(ZKDeploymentMessagePublisher.ERROR)) {
                            this.errorDesc = new String((byte[])ZKDeploymentMessagePublisher.this.getClient().getData().forPath(Paths.build(event.getPath(), ZKDeploymentMessagePublisher.ERROR)));
                            this.state = State.error;
                        } else {
                            this.state = State.success;
                        }
                        ZKDeploymentMessagePublisher.this.notifyAll();
                    }
                } else {
                    ZKDeploymentMessagePublisher.this.logger.debug("Ignoring event: {}", (Object)event);
                }
            }
        }
    }

    private static enum State {
        incomplete,
        success,
        error;

    }
}

