/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.ModuleDeploymentRequestsPath;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentHandler;
import org.springframework.xd.dirt.server.admin.deployment.zk.SupervisorElectedEvent;
import org.springframework.xd.dirt.server.admin.deployment.zk.SupervisorElectionListener;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public abstract class ZKDeploymentHandler
implements DeploymentHandler,
SupervisorElectionListener {
    @Autowired
    protected ZooKeeperConnection zkConnection;
    protected PathChildrenCache moduleDeploymentRequests;

    protected void createModuleDeploymentRequestsPath(CuratorFramework client, ModuleDescriptor descriptor, RuntimeModuleDeploymentProperties deploymentProperties) {
        String requestedModulesPath = new ModuleDeploymentRequestsPath().setDeploymentUnitName(descriptor.getGroup()).setModuleType(descriptor.getType().toString()).setModuleLabel(descriptor.getModuleLabel()).setModuleSequence(deploymentProperties.getSequenceAsString()).build();
        try {
            client.create().creatingParentsIfNeeded().forPath(requestedModulesPath, ZooKeeperUtils.mapToBytes((Map<String, String>)deploymentProperties));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    @Override
    public final void undeploy(String deploymentUnitName) throws Exception {
        Assert.notNull((Object)this.moduleDeploymentRequests, (String)"Module deployment request path cache shouldn't be null.");
        for (ChildData requestedModulesData : this.moduleDeploymentRequests.getCurrentData()) {
            ModuleDeploymentRequestsPath path = new ModuleDeploymentRequestsPath(requestedModulesData.getPath());
            if (!path.getDeploymentUnitName().equals(deploymentUnitName)) continue;
            this.zkConnection.getClient().delete().deletingChildrenIfNeeded().forPath(path.build());
        }
    }

    @Override
    public void onSupervisorElected(SupervisorElectedEvent supervisorElectedEvent) {
        this.moduleDeploymentRequests = supervisorElectedEvent.getModuleDeploymentRequests();
    }
}

