/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.NoContainerException;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.core.DeploymentUnit;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.core.JobDeploymentsPath;
import org.springframework.xd.dirt.core.ModuleDeploymentRequestsPath;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.core.StreamDeploymentsPath;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.dirt.server.admin.deployment.zk.DefaultModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public abstract class ModuleRedeployer {
    private final Logger logger = LoggerFactory.getLogger(ModuleRedeployer.class);
    private final ZooKeeperConnection zkConnection;
    private final ContainerRepository containerRepository;
    private final ContainerMatcher containerMatcher;
    private final ModuleDeploymentWriter moduleDeploymentWriter;
    protected final PathChildrenCache moduleDeploymentRequests;
    protected final StreamFactory streamFactory;
    protected final JobFactory jobFactory;
    private final DeploymentUnitStateCalculator stateCalculator;

    public ModuleRedeployer(ZooKeeperConnection zkConnection, ContainerRepository containerRepository, StreamFactory streamFactory, JobFactory jobFactory, PathChildrenCache moduleDeploymentRequests, ContainerMatcher containerMatcher, ModuleDeploymentWriter moduleDeploymentWriter, DeploymentUnitStateCalculator stateCalculator) {
        this.zkConnection = zkConnection;
        this.containerRepository = containerRepository;
        this.containerMatcher = containerMatcher;
        this.moduleDeploymentWriter = moduleDeploymentWriter;
        this.moduleDeploymentRequests = moduleDeploymentRequests;
        this.streamFactory = streamFactory;
        this.jobFactory = jobFactory;
        this.stateCalculator = stateCalculator;
    }

    protected abstract void deployModules(Container var1) throws Exception;

    protected CuratorFramework getClient() {
        return this.zkConnection.getClient();
    }

    private List<String> getContainersForStreamModule(ModuleDescriptor descriptor) throws Exception {
        ArrayList<String> containers = new ArrayList<String>();
        String moduleType = descriptor.getModuleDefinition().getType().toString();
        String moduleLabel = descriptor.getModuleLabel();
        String moduleDeploymentPath = Paths.build("deployments/streams", descriptor.getGroup(), "modules");
        try {
            List moduleDeployments = (List)this.getClient().getChildren().forPath(moduleDeploymentPath);
            for (String moduleDeployment : moduleDeployments) {
                StreamDeploymentsPath path = new StreamDeploymentsPath(Paths.build(moduleDeploymentPath, moduleDeployment));
                if (!path.getModuleType().equals(moduleType) || !path.getModuleLabel().equals(moduleLabel)) continue;
                containers.add(path.getContainer());
            }
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        return containers;
    }

    private List<String> getContainersForJobModule(ModuleDescriptor descriptor) throws Exception {
        ArrayList<String> containers = new ArrayList<String>();
        String moduleLabel = descriptor.getModuleLabel();
        String moduleDeploymentPath = Paths.build("deployments/jobs", descriptor.getGroup(), "modules");
        try {
            List moduleDeployments = (List)this.getClient().getChildren().forPath(moduleDeploymentPath);
            for (String moduleDeployment : moduleDeployments) {
                JobDeploymentsPath path = new JobDeploymentsPath(Paths.build(moduleDeploymentPath, moduleDeployment));
                if (!path.getModuleLabel().equals(moduleLabel)) continue;
                containers.add(path.getContainer());
            }
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        return containers;
    }

    protected void logUnwantedRedeployment(String criteria, String moduleLabel) {
        StringBuilder builder = new StringBuilder();
        builder.append("Module '").append(moduleLabel).append("' is targeted to all containers");
        if (StringUtils.hasText((String)criteria)) {
            builder.append(" matching criteria '").append(criteria).append('\'');
        }
        builder.append("; it does not need to be redeployed");
        this.logger.info(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redeployModule(ModuleDeployment moduleDeployment, boolean arriving) throws Exception {
        block4: {
            RuntimeModuleDeploymentProperties deploymentProperties;
            ModuleDescriptor moduleDescriptor;
            block5: {
                DeploymentUnit deploymentUnit = moduleDeployment.deploymentUnit;
                moduleDescriptor = moduleDeployment.moduleDescriptor;
                deploymentProperties = moduleDeployment.runtimeDeploymentProperties;
                ModuleDeploymentStatus deploymentStatus = null;
                if (!arriving && deploymentProperties.getCount() <= 0) break block5;
                try {
                    List<String> containers = moduleDescriptor.getType() == ModuleType.job ? this.getContainersForJobModule(moduleDescriptor) : this.getContainersForStreamModule(moduleDescriptor);
                    deploymentStatus = this.deployModule(moduleDeployment, this.containerMatcher, containers);
                }
                catch (NoContainerException e) {
                    try {
                        this.logger.warn("No containers available for redeployment of {} for stream {}", (Object)moduleDescriptor.getModuleLabel(), (Object)deploymentUnit.getName());
                    }
                    catch (Throwable throwable) {
                        this.updateDeploymentUnitState(moduleDeployment, deploymentStatus);
                        throw throwable;
                    }
                    this.updateDeploymentUnitState(moduleDeployment, deploymentStatus);
                    break block4;
                }
                this.updateDeploymentUnitState(moduleDeployment, deploymentStatus);
                break block4;
            }
            this.logUnwantedRedeployment(deploymentProperties.getCriteria(), moduleDescriptor.getModuleLabel());
        }
    }

    private ModuleDeploymentStatus deployModule(ModuleDeployment moduleDeployment, ContainerMatcher containerMatcher, Collection<String> exclusions) throws Exception {
        this.transitionToDeploying(moduleDeployment.deploymentUnit);
        Iterable containers = this.containerRepository.findAll();
        MatchingPredicate matchingPredicate = new MatchingPredicate(exclusions);
        Collection<Container> matchedContainers = containerMatcher.match(moduleDeployment.moduleDescriptor, (ModuleDeploymentProperties)moduleDeployment.runtimeDeploymentProperties, Iterables.filter((Iterable)containers, (Predicate)matchingPredicate));
        if (matchedContainers.isEmpty()) {
            throw new NoContainerException();
        }
        return this.moduleDeploymentWriter.writeDeployment(moduleDeployment.moduleDescriptor, moduleDeployment.runtimeDeploymentProperties, matchedContainers.iterator().next());
    }

    private void transitionToDeploying(DeploymentUnit deploymentUnit) throws Exception {
        String pathPrefix = deploymentUnit instanceof Stream ? "deployments/streams" : "deployments/jobs";
        this.getClient().setData().forPath(Paths.build(pathPrefix, deploymentUnit.getName(), "status"), ZooKeeperUtils.mapToBytes(new DeploymentUnitStatus(DeploymentUnitStatus.State.deploying).toMap()));
    }

    private Collection<ModuleDeploymentStatus> aggregateState(DeploymentUnit deploymentUnit) throws Exception {
        Assert.state((deploymentUnit instanceof Stream || deploymentUnit instanceof Job ? 1 : 0) != 0);
        String pathPrefix = deploymentUnit instanceof Stream ? "deployments/streams" : "deployments/jobs";
        String path = Paths.build(pathPrefix, deploymentUnit.getName(), "modules");
        List modules = (List)this.getClient().getChildren().forPath(path);
        ArrayList<ModuleDeploymentStatus> results = new ArrayList<ModuleDeploymentStatus>();
        for (String module : modules) {
            String container;
            int moduleSequence;
            String label;
            ModuleType type;
            String deploymentUnitName;
            if (deploymentUnit instanceof Stream) {
                StreamDeploymentsPath streamDeploymentsPath = new StreamDeploymentsPath(Paths.build(path, module));
                deploymentUnitName = streamDeploymentsPath.getStreamName();
                Assert.state((boolean)deploymentUnitName.equals(deploymentUnit.getName()));
                type = ModuleType.valueOf((String)streamDeploymentsPath.getModuleType());
                label = streamDeploymentsPath.getModuleLabel();
                moduleSequence = streamDeploymentsPath.getModuleSequence();
                container = streamDeploymentsPath.getContainer();
            } else {
                JobDeploymentsPath jobDeploymentsPath = new JobDeploymentsPath(Paths.build(path, module));
                deploymentUnitName = jobDeploymentsPath.getJobName();
                Assert.state((boolean)deploymentUnitName.equals(deploymentUnit.getName()));
                type = ModuleType.job;
                label = jobDeploymentsPath.getModuleLabel();
                moduleSequence = jobDeploymentsPath.getModuleSequence();
                container = jobDeploymentsPath.getContainer();
            }
            ModuleDescriptor.Key moduleDescriptorKey = new ModuleDescriptor.Key(deploymentUnitName, type, label);
            results.add(new ModuleDeploymentStatus(container, moduleSequence, moduleDescriptorKey, ModuleDeploymentStatus.State.deployed, null));
        }
        return results;
    }

    protected void updateDeploymentUnitState(ModuleDeployment moduleDeployment, ModuleDeploymentStatus deploymentStatus) throws Exception {
        DeploymentUnit deploymentUnit = moduleDeployment.deploymentUnit;
        ModuleDescriptor moduleDescriptor = moduleDeployment.moduleDescriptor;
        Collection<ModuleDeploymentStatus> aggregateStatuses = this.aggregateState(deploymentUnit);
        if (deploymentStatus != null) {
            Iterator<ModuleDeploymentStatus> iterator = aggregateStatuses.iterator();
            while (iterator.hasNext()) {
                ModuleDeploymentStatus status = iterator.next();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("module deployment status: {}", (Object)status);
                    this.logger.trace("deploymentStatus: {}", (Object)deploymentStatus);
                }
                if (!status.getKey().getLabel().equals(moduleDescriptor.getModuleLabel()) || !status.getContainer().equals(deploymentStatus.getContainer())) continue;
                iterator.remove();
            }
            aggregateStatuses.add(deploymentStatus);
        }
        Assert.state((deploymentUnit instanceof Stream || deploymentUnit instanceof Job ? 1 : 0) != 0);
        boolean isStream = deploymentUnit instanceof Stream;
        DefaultModuleDeploymentPropertiesProvider provider = new DefaultModuleDeploymentPropertiesProvider(deploymentUnit);
        DeploymentUnitStatus status = this.stateCalculator.calculate(deploymentUnit, provider, aggregateStatuses);
        this.logger.info("Deployment state for {} '{}': {}", new Object[]{isStream ? "stream" : "job", deploymentUnit.getName(), status});
        this.getClient().setData().forPath(Paths.build(isStream ? "deployments/streams" : "deployments/jobs", deploymentUnit.getName(), "status"), ZooKeeperUtils.mapToBytes(status.toMap()));
    }

    protected List<ModuleDeploymentRequestsPath> getAllModuleDeploymentRequests() {
        ArrayList<ModuleDeploymentRequestsPath> requestedModulesPaths = new ArrayList<ModuleDeploymentRequestsPath>();
        for (ChildData requestedModulesData : this.moduleDeploymentRequests.getCurrentData()) {
            requestedModulesPaths.add(new ModuleDeploymentRequestsPath(requestedModulesData.getPath()));
        }
        return requestedModulesPaths;
    }

    private class MatchingPredicate
    implements Predicate<Container> {
        private final Set<String> exclusions;

        private MatchingPredicate(Collection<String> exclusions) {
            Assert.notNull(exclusions);
            this.exclusions = Collections.unmodifiableSet(new HashSet<String>(exclusions));
        }

        public boolean apply(Container input) {
            return input != null && !this.exclusions.contains(input.getName());
        }
    }

    protected static class ModuleDeployment
    implements Comparable<ModuleDeployment> {
        protected final DeploymentUnit deploymentUnit;
        protected final ModuleDescriptor moduleDescriptor;
        protected final RuntimeModuleDeploymentProperties runtimeDeploymentProperties;

        ModuleDeployment(DeploymentUnit deploymentUnit, ModuleDescriptor moduleDescriptor, RuntimeModuleDeploymentProperties runtimeDeploymentProperties) {
            this.deploymentUnit = deploymentUnit;
            this.moduleDescriptor = moduleDescriptor;
            this.runtimeDeploymentProperties = runtimeDeploymentProperties;
        }

        @Override
        public int compareTo(ModuleDeployment o) {
            int c = this.deploymentUnit.getName().compareTo(o.deploymentUnit.getName());
            if (c == 0) {
                c = o.moduleDescriptor.getIndex() - this.moduleDescriptor.getIndex();
            }
            return c;
        }
    }
}

