/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.NoContainerException;
import org.springframework.xd.dirt.core.ModuleDeploymentsPath;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public class ModuleDeploymentWriter {
    private static final Logger logger = LoggerFactory.getLogger(ModuleDeploymentWriter.class);
    @Autowired
    private ZooKeeperConnection zkConnection;
    @Value(value="${xd.admin.deploymentTimeout:30000}")
    private long deploymentTimeout;

    protected ModuleDeploymentStatus writeDeployment(ModuleDescriptor moduleDescriptor, RuntimeModuleDeploymentProperties deploymentProperties, Container container) throws InterruptedException, NoContainerException {
        ResultCollector collector = new ResultCollector();
        this.writeDeployment(moduleDescriptor, deploymentProperties, container, collector);
        Collection<ModuleDeploymentStatus> statuses = this.processResults(collector);
        if (statuses.isEmpty()) {
            throw new NoContainerException();
        }
        return statuses.iterator().next();
    }

    protected Collection<ModuleDeploymentStatus> writeDeployment(ModuleDescriptor moduleDescriptor, ModuleDeploymentPropertiesProvider<RuntimeModuleDeploymentProperties> provider, Collection<Container> containers) throws InterruptedException, NoContainerException {
        ResultCollector collector = new ResultCollector();
        for (Container container : containers) {
            this.writeDeployment(moduleDescriptor, provider.propertiesForDescriptor(moduleDescriptor), container, collector);
        }
        Collection<ModuleDeploymentStatus> statuses = this.processResults(collector);
        if (statuses.isEmpty()) {
            throw new NoContainerException();
        }
        return statuses;
    }

    private void writeDeployment(ModuleDescriptor moduleDescriptor, RuntimeModuleDeploymentProperties runtimeProperties, Container container, ResultCollector collector) throws InterruptedException, NoContainerException {
        int moduleSequence = runtimeProperties.getSequence();
        String containerName = container.getName();
        String deploymentPath = new ModuleDeploymentsPath().setContainer(containerName).setDeploymentUnitName(moduleDescriptor.getGroup()).setModuleType(moduleDescriptor.getType().toString()).setModuleLabel(moduleDescriptor.getModuleLabel()).setModuleSequence(String.valueOf(moduleSequence)).build();
        String statusPath = Paths.build(deploymentPath, "status");
        collector.addPending(containerName, moduleSequence, moduleDescriptor.createKey());
        try {
            this.ensureModuleDeploymentPath(deploymentPath, statusPath, moduleDescriptor, (ModuleDeploymentProperties)runtimeProperties, container);
            byte[] data = (byte[])((BackgroundPathable)this.zkConnection.getClient().getData().usingWatcher((CuratorWatcher)collector)).forPath(statusPath);
            if (data != null && data.length > 0) {
                collector.addResult(this.createResult(deploymentPath, data));
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            collector.addResult(this.createResult(deploymentPath, e));
        }
    }

    protected Collection<ModuleDeploymentStatus> processResults(ResultCollector collector) throws InterruptedException {
        Collection<ModuleDeploymentStatus> statuses = collector.getResults();
        for (ModuleDeploymentStatus deploymentStatus : statuses) {
            if (deploymentStatus.getState() == ModuleDeploymentStatus.State.deployed) continue;
            String path = new ModuleDeploymentsPath().setContainer(deploymentStatus.getContainer()).setDeploymentUnitName(deploymentStatus.getKey().getGroup()).setModuleType(deploymentStatus.getKey().getType().toString()).setModuleLabel(deploymentStatus.getKey().getLabel()).setModuleSequence(deploymentStatus.getModuleSequenceAsString()).build();
            logger.debug("Unsuccessful deployment: {}; removing path {}", (Object)deploymentStatus, (Object)path);
            try {
                this.zkConnection.getClient().delete().deletingChildrenIfNeeded().forPath(path);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (Exception e) {
                logger.warn("Error while cleaning up failed deployment " + path, (Throwable)e);
            }
        }
        return statuses;
    }

    private void ensureModuleDeploymentPath(String deploymentPath, String statusPath, ModuleDescriptor descriptor, ModuleDeploymentProperties properties, Container container) throws Exception {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.zkConnection.getClient().inTransaction().create().forPath(deploymentPath, ZooKeeperUtils.mapToBytes((Map<String, String>)properties))).and().create().forPath(statusPath)).and().commit();
        }
        catch (KeeperException.NodeExistsException e) {
            logger.info("Module {} is already deployed to container {}", (Object)descriptor, (Object)container);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(String.format("Error creating the following deployment paths: %s, %s", deploymentPath, statusPath), (Throwable)e);
            throw e;
        }
    }

    private ModuleDeploymentStatus createResult(String pathString, byte[] data) {
        return this.createResult(pathString, ZooKeeperUtils.bytesToMap(data));
    }

    private ModuleDeploymentStatus createResult(String pathString, Map<String, String> statusMap) {
        ModuleDeploymentsPath path = new ModuleDeploymentsPath(pathString);
        ModuleDescriptor.Key key = new ModuleDescriptor.Key(path.getDeploymentUnitName(), ModuleType.valueOf((String)path.getModuleType()), path.getModuleLabel());
        return new ModuleDeploymentStatus(path.getContainer(), path.getModuleSequence(), key, statusMap);
    }

    private ModuleDeploymentStatus createResult(String pathString, Throwable t) {
        ModuleDeploymentsPath path = new ModuleDeploymentsPath(pathString);
        ModuleDescriptor.Key key = new ModuleDescriptor.Key(path.getDeploymentUnitName(), ModuleType.valueOf((String)path.getModuleType()), path.getModuleLabel());
        return new ModuleDeploymentStatus(path.getContainer(), path.getModuleSequence(), key, ModuleDeploymentStatus.State.failed, ZooKeeperUtils.getStackTrace(t));
    }

    private class ResultCollector
    implements CuratorWatcher {
        private final Set<ContainerModuleKey> pending = new HashSet<ContainerModuleKey>();
        private final Map<ContainerModuleKey, ModuleDeploymentStatus> results = new HashMap<ContainerModuleKey, ModuleDeploymentStatus>();

        private ResultCollector() {
        }

        public void process(WatchedEvent event) throws Exception {
            logger.trace("EventCollector received event: {}", (Object)event);
            if (EnumSet.of(Watcher.Event.KeeperState.SyncConnected, Watcher.Event.KeeperState.SaslAuthenticated, Watcher.Event.KeeperState.ConnectedReadOnly).contains(event.getState())) {
                if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    byte[] data = (byte[])ModuleDeploymentWriter.this.zkConnection.getClient().getData().forPath(event.getPath());
                    this.addResult(ModuleDeploymentWriter.this.createResult(event.getPath(), data));
                } else {
                    logger.debug("Ignoring event: {}", (Object)event);
                }
            }
        }

        public synchronized void addPending(String container, int moduleSequence, ModuleDescriptor.Key key) {
            this.pending.add(new ContainerModuleKey(container, moduleSequence, key));
        }

        public synchronized void addResult(ModuleDeploymentStatus deploymentStatus) {
            ContainerModuleKey key = new ContainerModuleKey(deploymentStatus.getContainer(), deploymentStatus.getModuleSequence(), deploymentStatus.getKey());
            this.pending.remove(key);
            this.results.put(key, deploymentStatus);
            this.notifyAll();
        }

        public synchronized Collection<ModuleDeploymentStatus> getResults() throws InterruptedException {
            long now = System.currentTimeMillis();
            long expiryTime = now + ModuleDeploymentWriter.this.deploymentTimeout;
            while (this.pending.size() > 0 && now < expiryTime) {
                this.wait(expiryTime - now);
                now = System.currentTimeMillis();
            }
            for (ContainerModuleKey key : this.pending) {
                this.results.put(key, new ModuleDeploymentStatus(key.container, key.moduleSequence, key.moduleDescriptorKey, ModuleDeploymentStatus.State.failed, String.format("Deployment of module '%s' to container '%s' timed out after %d ms", key.moduleDescriptorKey, key.container, ModuleDeploymentWriter.this.deploymentTimeout)));
            }
            return this.results.values();
        }
    }

    private class ContainerModuleKey {
        private String container;
        private int moduleSequence;
        private ModuleDescriptor.Key moduleDescriptorKey;

        private ContainerModuleKey(String container, int moduleSequence, ModuleDescriptor.Key moduleDescriptorKey) {
            this.container = container;
            this.moduleSequence = moduleSequence;
            this.moduleDescriptorKey = moduleDescriptorKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerModuleKey that = (ContainerModuleKey)o;
            return this.container.equals(that.container) && this.moduleSequence == that.moduleSequence && this.moduleDescriptorKey.equals((Object)that.moduleDescriptorKey);
        }

        public int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + this.moduleSequence;
            result = 31 * result + this.moduleDescriptorKey.hashCode();
            return result;
        }

        public String toString() {
            return "ContainerModuleKey{container='" + this.container + '\'' + "moduleSequence'" + this.moduleSequence + '\'' + ", moduleDescriptorKey=" + this.moduleDescriptorKey + '}';
        }
    }
}

