/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.queue.DistributedQueue;
import org.apache.curator.framework.recipes.queue.QueueBuilder;
import org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.curator.framework.recipes.queue.QueueSerializer;
import org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessage;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;

public class DeploymentQueue
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentQueue.class);
    private DistributedQueue<DeploymentMessage> distributedQueue;
    private final QueueConsumer<DeploymentMessage> queueConsumer;
    private final CuratorFramework client;
    private final String deploymentQueuePath;
    private final ObjectWriter objectWriter = new ObjectMapper().writerWithType(DeploymentMessage.class);
    private final ObjectReader objectReader = new ObjectMapper().reader(DeploymentMessage.class);
    private final ExecutorService executorService;

    public DeploymentQueue(ZooKeeperConnection zkConnection) {
        this(zkConnection.getClient(), null, "queue/deployments", Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory((String)"DeploymentQueue")));
    }

    public DeploymentQueue(CuratorFramework client, QueueConsumer queueConsumer, String deploymentQueuePath, ExecutorService executorService) {
        this.client = client;
        this.queueConsumer = queueConsumer;
        this.deploymentQueuePath = deploymentQueuePath;
        this.executorService = executorService;
    }

    public void start() throws Exception {
        if (this.client != null) {
            QueueBuilder builder = QueueBuilder.builder((CuratorFramework)this.client, this.queueConsumer, (QueueSerializer)new DeploymentMessageSerializer(), (String)this.deploymentQueuePath);
            this.distributedQueue = builder.executor((Executor)this.executorService).buildQueue();
            this.distributedQueue.start();
        }
    }

    public DistributedQueue<DeploymentMessage> getDistributedQueue() {
        return this.distributedQueue;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public void destroy() throws Exception {
        this.distributedQueue.close();
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    private class DeploymentMessageSerializer
    implements QueueSerializer<DeploymentMessage> {
        private DeploymentMessageSerializer() {
        }

        public DeploymentMessage deserialize(byte[] buffer) {
            DeploymentMessage deploymentMessage = null;
            try {
                deploymentMessage = (DeploymentMessage)DeploymentQueue.this.objectReader.readValue(buffer);
            }
            catch (JsonProcessingException e) {
                logger.error("Json processing exception when de-serializing." + (Object)((Object)e));
            }
            catch (IOException ioe) {
                logger.error("IO exception exception when de-serializing." + ioe);
            }
            return deploymentMessage;
        }

        public byte[] serialize(DeploymentMessage message) {
            byte[] byteArray = null;
            try {
                byteArray = DeploymentQueue.this.objectWriter.writeValueAsBytes((Object)message);
            }
            catch (JsonMappingException e) {
                logger.error("Json processing exception when serializing." + (Object)((Object)e));
            }
            catch (IOException ioe) {
                logger.error("IO processing exception when de-serializing." + ioe);
            }
            return byteArray;
        }
    }
}

