/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.Collections;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.ResourceDeployer;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentAction;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentMessage;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.dirt.stream.JobDeployer;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.stream.StreamDeployer;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class DeploymentMessageConsumer
implements QueueConsumer<DeploymentMessage> {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentMessageConsumer.class);
    @Autowired
    private StreamDeployer streamDeployer;
    @Autowired
    private JobDeployer jobDeployer;
    @Autowired
    private ZooKeeperConnection zkConnection;

    public void consumeMessage(DeploymentMessage message, StreamDeployer streamDeployer, JobDeployer jobDeployer) throws Exception {
        this.streamDeployer = streamDeployer;
        this.jobDeployer = jobDeployer;
        this.consumeMessage(message);
    }

    public void consumeMessage(DeploymentMessage deploymentMessage) throws Exception {
        switch (deploymentMessage.getDeploymentUnitType()) {
            case Stream: {
                this.processDeploymentMessage(this.streamDeployer, deploymentMessage);
                break;
            }
            case Job: {
                this.processDeploymentMessage(this.jobDeployer, deploymentMessage);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDeploymentMessage(ResourceDeployer deployer, DeploymentMessage message) {
        DeploymentAction deploymentAction = message.getDeploymentAction();
        String name = message.getUnitName();
        String errorDesc = null;
        try {
            switch (deploymentAction) {
                case create: 
                case createAndDeploy: {
                    if (deployer instanceof StreamDeployer) {
                        deployer.save(new StreamDefinition(name, message.getDefinition()));
                    } else if (deployer instanceof JobDeployer) {
                        deployer.save(new JobDefinition(name, message.getDefinition()));
                    }
                    if (!DeploymentAction.createAndDeploy.equals((Object)deploymentAction)) return;
                    deployer.deploy(name, Collections.emptyMap());
                    return;
                }
                case deploy: {
                    deployer.deploy(name, message.getDeploymentProperties());
                    return;
                }
                case undeploy: {
                    deployer.undeploy(name);
                    return;
                }
                case undeployAll: {
                    deployer.undeployAll();
                    return;
                }
                case destroy: {
                    deployer.delete(name);
                    return;
                }
                case destroyAll: {
                    deployer.deleteAll();
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            errorDesc = ZooKeeperUtils.getStackTrace(t);
            throw t;
        }
        finally {
            this.writeResponse(message, errorDesc);
        }
    }

    private void writeResponse(DeploymentMessage message, String errorDesc) {
        try {
            String requestId = message.getRequestId();
            if (StringUtils.hasText((String)requestId)) {
                logger.debug("Processed deployment request " + requestId);
                String resultPath = Paths.build("deployments", "responses", requestId, errorDesc == null ? "success" : "error");
                logger.debug("creating result path {}", (Object)resultPath);
                this.zkConnection.getClient().create().forPath(resultPath, errorDesc == null ? null : errorDesc.getBytes());
            }
        }
        catch (Exception e) {
            logger.info("Could not publish response to deployment message", (Throwable)e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        logger.debug("Deployment Queue consumer state changed: " + newState);
    }
}

