/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class DeploymentLoader {
    public static Job loadJob(CuratorFramework client, String jobName, JobFactory jobFactory) throws Exception {
        try {
            byte[] definition = (byte[])client.getData().forPath(Paths.build("jobs", jobName));
            Map<String, String> definitionMap = ZooKeeperUtils.bytesToMap(definition);
            byte[] deploymentPropertiesData = (byte[])client.getData().forPath(Paths.build("deployments/jobs", jobName));
            if (deploymentPropertiesData != null && deploymentPropertiesData.length > 0) {
                definitionMap.put("deploymentProperties", new String(deploymentPropertiesData, "UTF-8"));
            }
            return jobFactory.createJob(jobName, definitionMap);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
    }

    public static Stream loadStream(CuratorFramework client, String streamName, StreamFactory streamFactory) throws Exception {
        try {
            byte[] definition = (byte[])client.getData().forPath(Paths.build("streams", streamName));
            Map<String, String> definitionMap = ZooKeeperUtils.bytesToMap(definition);
            byte[] deploymentPropertiesData = (byte[])client.getData().forPath(Paths.build("deployments/streams", streamName));
            if (deploymentPropertiesData != null && deploymentPropertiesData.length > 0) {
                definitionMap.put("deploymentProperties", new String(deploymentPropertiesData, "UTF-8"));
            }
            return streamFactory.createStream(streamName, definitionMap);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
    }
}

