/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.AuditAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.CrudRepository;
import org.springframework.xd.dirt.cluster.AdminAttributes;
import org.springframework.xd.dirt.container.store.AdminRepository;
import org.springframework.xd.dirt.container.store.ZooKeeperAdminRepository;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.server.admin.deployment.DefaultDeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.zk.DefaultDeploymentStateRecalculator;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentMessageConsumer;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentQueue;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentSupervisor;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ZKDeploymentMessagePublisher;
import org.springframework.xd.dirt.server.admin.deployment.zk.ZKJobDeploymentHandler;
import org.springframework.xd.dirt.server.admin.deployment.zk.ZKStreamDeploymentHandler;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xd.dirt.stream.JobDeployer;
import org.springframework.xd.dirt.stream.JobRepository;
import org.springframework.xd.dirt.stream.StreamDefinitionRepository;
import org.springframework.xd.dirt.stream.StreamDeployer;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.stream.StreamRepository;
import org.springframework.xd.dirt.stream.XDParser;
import org.springframework.xd.dirt.stream.XDStreamParser;
import org.springframework.xd.dirt.util.RuntimeUtils;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;

@Configuration
@EnableAutoConfiguration(exclude={BatchAutoConfiguration.class, JmxAutoConfiguration.class, AuditAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, SolrAutoConfiguration.class})
public class DeploymentConfiguration {
    @Autowired
    private ZooKeeperConnection zkConnection;
    @Autowired
    private StreamDefinitionRepository streamDefinitionRepository;
    @Autowired
    private StreamRepository streamRepository;
    @Autowired
    private JobDefinitionRepository jobDefinitionRepository;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private ModuleRegistry moduleRegistry;
    @Autowired
    private ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;
    @Autowired
    private MessageBus messageBus;

    @Bean
    public XDStreamParser parser() {
        return new XDStreamParser((CrudRepository<? extends BaseDefinition, String>)this.streamDefinitionRepository, this.moduleRegistry, this.moduleOptionsMetadataResolver);
    }

    @Bean
    public StreamFactory streamFactory() {
        return new StreamFactory(this.streamDefinitionRepository, this.moduleRegistry, this.moduleOptionsMetadataResolver);
    }

    @Bean
    public JobFactory jobFactory() {
        return new JobFactory(this.jobDefinitionRepository, this.moduleRegistry, this.moduleOptionsMetadataResolver);
    }

    @Bean
    public DeploymentUnitStateCalculator deploymentUnitStateCalculator() {
        return new DefaultDeploymentUnitStateCalculator();
    }

    @Bean
    public ZKStreamDeploymentHandler streamDeploymentHandler() {
        return new ZKStreamDeploymentHandler();
    }

    @Bean
    public StreamDeployer zkStreamDeployer() {
        return new StreamDeployer(this.zkConnection, this.streamDefinitionRepository, this.streamRepository, this.parser(), this.streamDeploymentHandler());
    }

    @Bean
    public ZKJobDeploymentHandler jobDeploymentHandler() {
        return new ZKJobDeploymentHandler();
    }

    @Bean
    public JobDeployer zkJobDeployer() {
        return new JobDeployer(this.zkConnection, this.jobDefinitionRepository, this.jobRepository, (XDParser)this.parser(), this.messageBus, this.jobDeploymentHandler());
    }

    @Bean
    public AdminAttributes adminAttributes() {
        AdminAttributes adminAttributes = new AdminAttributes();
        adminAttributes.setHost(RuntimeUtils.getHost()).setIp(RuntimeUtils.getIpAddress()).setPid(RuntimeUtils.getPid());
        return adminAttributes;
    }

    @Bean
    public DeploymentSupervisor deploymentSupervisor() {
        return new DeploymentSupervisor(this.adminAttributes());
    }

    @Bean
    public ModuleDeploymentWriter moduleDeploymentWriter() {
        return new ModuleDeploymentWriter();
    }

    @Bean
    public DefaultDeploymentStateRecalculator stateCalculator() {
        return new DefaultDeploymentStateRecalculator();
    }

    @Bean
    public DeploymentQueue deploymentQueue() {
        return new DeploymentQueue(this.zkConnection);
    }

    @Bean
    public ZKDeploymentMessagePublisher deploymentMessageProducer() {
        return new ZKDeploymentMessagePublisher(this.deploymentQueue());
    }

    @Bean
    public DeploymentMessageConsumer deploymentMessageConsumer() {
        return new DeploymentMessageConsumer();
    }

    @Bean
    public AdminRepository adminRepository() {
        return new ZooKeeperAdminRepository(this.zkConnection);
    }
}

