/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.core.ModuleDeploymentsPath;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentLoader;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleRedeployer;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public class DepartedContainerModuleRedeployer
extends ModuleRedeployer {
    protected final Logger logger = LoggerFactory.getLogger(DepartedContainerModuleRedeployer.class);

    public DepartedContainerModuleRedeployer(ZooKeeperConnection zkConnection, ContainerRepository containerRepository, StreamFactory streamFactory, JobFactory jobFactory, PathChildrenCache moduleDeploymentRequests, ContainerMatcher containerMatcher, ModuleDeploymentWriter moduleDeploymentWriter, DeploymentUnitStateCalculator stateCalculator) {
        super(zkConnection, containerRepository, streamFactory, jobFactory, moduleDeploymentRequests, containerMatcher, moduleDeploymentWriter, stateCalculator);
    }

    @Override
    protected void deployModules(Container container) throws Exception {
        CuratorFramework client = this.getClient();
        if (client.getState() == CuratorFrameworkState.STOPPED) {
            return;
        }
        HashMap<String, Stream> streamMap = new HashMap<String, Stream>();
        String containerDeployments = Paths.build("deployments/modules", "allocated", container.getName());
        List deployments = (List)client.getChildren().forPath(containerDeployments);
        TreeSet<ModuleRedeployer.ModuleDeployment> streamModuleDeployments = new TreeSet<ModuleRedeployer.ModuleDeployment>();
        for (String deployment : deployments) {
            ModuleDeploymentsPath moduleDeploymentsPath = new ModuleDeploymentsPath(Paths.build(containerDeployments, deployment));
            RuntimeModuleDeploymentProperties deploymentProperties = new RuntimeModuleDeploymentProperties();
            deploymentProperties.putAll(ZooKeeperUtils.bytesToMap((byte[])client.getData().forPath(moduleDeploymentsPath.build())));
            String unitName = moduleDeploymentsPath.getDeploymentUnitName();
            String moduleType = moduleDeploymentsPath.getModuleType();
            if (ModuleType.job.toString().equals(moduleType)) {
                try {
                    Job job = DeploymentLoader.loadJob(client, unitName, this.jobFactory);
                    if (job == null) continue;
                    this.redeployModule(new ModuleRedeployer.ModuleDeployment(job, job.getJobModuleDescriptor(), deploymentProperties), false);
                }
                catch (Exception e) {
                    this.logger.error(String.format("Exception loading job %s", unitName), (Throwable)e);
                }
                continue;
            }
            Stream stream = (Stream)streamMap.get(unitName);
            if (stream != null) continue;
            try {
                stream = DeploymentLoader.loadStream(client, unitName, this.streamFactory);
                streamMap.put(unitName, stream);
                if (stream == null) continue;
                streamModuleDeployments.add(new ModuleRedeployer.ModuleDeployment(stream, stream.getModuleDescriptor(moduleDeploymentsPath.getModuleLabel()), deploymentProperties));
            }
            catch (Exception e) {
                this.logger.error(String.format("Exception loading stream %s.", unitName), (Throwable)e);
            }
        }
        for (ModuleRedeployer.ModuleDeployment moduleDeployment : streamModuleDeployments) {
            this.redeployModule(moduleDeployment, false);
        }
        client.delete().deletingChildrenIfNeeded().forPath(Paths.build("deployments/modules", "allocated", container.getName()));
    }
}

