/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.core.JobDeploymentsPath;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.core.StreamDeploymentsPath;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitType;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentStatus;
import org.springframework.xd.dirt.server.admin.deployment.zk.DefaultModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentLoader;
import org.springframework.xd.dirt.server.admin.deployment.zk.SupervisorElectedEvent;
import org.springframework.xd.dirt.server.admin.deployment.zk.SupervisorElectionListener;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.ChildPathIterator;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;

public class DefaultDeploymentStateRecalculator
implements SupervisorElectionListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDeploymentStateRecalculator.class);
    @Autowired
    private ZooKeeperConnection zkConnection;
    @Autowired
    protected StreamFactory streamFactory;
    @Autowired
    protected JobFactory jobFactory;
    @Autowired
    protected DeploymentUnitStateCalculator stateCalculator;

    public void recalculateStreamStates(PathChildrenCache streamDeployments) throws Exception {
        Assert.notNull((Object)streamDeployments, (String)"Stream deployment path cache shouldn't be null.");
        CuratorFramework client = this.zkConnection.getClient();
        ChildPathIterator<String> iterator = new ChildPathIterator<String>(ZooKeeperUtils.stripPathConverter, streamDeployments);
        while (iterator.hasNext()) {
            String streamName = (String)iterator.next();
            String definitionPath = Paths.build(Paths.build("deployments/streams", streamName));
            try {
                Stream stream = DeploymentLoader.loadStream(client, streamName, this.streamFactory);
                if (stream == null) continue;
                String streamModulesPath = Paths.build(definitionPath, "modules");
                ArrayList<ModuleDeploymentStatus> statusList = new ArrayList<ModuleDeploymentStatus>();
                try {
                    List moduleDeployments = (List)client.getChildren().forPath(streamModulesPath);
                    for (String moduleDeployment : moduleDeployments) {
                        StreamDeploymentsPath streamDeploymentsPath = new StreamDeploymentsPath(Paths.build(streamModulesPath, moduleDeployment));
                        statusList.add(new ModuleDeploymentStatus(streamDeploymentsPath.getContainer(), streamDeploymentsPath.getModuleSequence(), new ModuleDescriptor.Key(streamName, ModuleType.valueOf((String)streamDeploymentsPath.getModuleType()), streamDeploymentsPath.getModuleLabel()), ModuleDeploymentStatus.State.deployed, null));
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    // empty catch block
                }
                this.writeDeploymentUnitStatus(DeploymentUnitType.Stream, streamName, this.stateCalculator.calculate(stream, new DefaultModuleDeploymentPropertiesProvider(stream), statusList));
            }
            catch (Exception e) {
                logger.error(String.format("Exception calculating status for stream %s; status will be set to %s.", new Object[]{streamName, DeploymentUnitStatus.State.unknown}), (Throwable)e);
                this.writeDeploymentUnitStatus(DeploymentUnitType.Stream, streamName, new DeploymentUnitStatus(DeploymentUnitStatus.State.unknown));
            }
        }
    }

    public void recalculateJobStates(PathChildrenCache jobDeployments) throws Exception {
        Assert.notNull((Object)jobDeployments, (String)"Stream deployment path cache shouldn't be null.");
        CuratorFramework client = this.zkConnection.getClient();
        ChildPathIterator<String> iterator = new ChildPathIterator<String>(ZooKeeperUtils.stripPathConverter, jobDeployments);
        while (iterator.hasNext()) {
            String jobName = (String)iterator.next();
            try {
                Job job = DeploymentLoader.loadJob(client, jobName, this.jobFactory);
                if (job == null) continue;
                String jobModulesPath = Paths.build("deployments/jobs", jobName, "modules");
                ArrayList<ModuleDeploymentStatus> statusList = new ArrayList<ModuleDeploymentStatus>();
                List moduleDeployments = (List)client.getChildren().forPath(jobModulesPath);
                for (String moduleDeployment : moduleDeployments) {
                    JobDeploymentsPath jobDeploymentsPath = new JobDeploymentsPath(Paths.build(jobModulesPath, moduleDeployment));
                    statusList.add(new ModuleDeploymentStatus(jobDeploymentsPath.getContainer(), jobDeploymentsPath.getModuleSequence(), new ModuleDescriptor.Key(jobName, ModuleType.job, jobDeploymentsPath.getModuleLabel()), ModuleDeploymentStatus.State.deployed, null));
                }
                this.writeDeploymentUnitStatus(DeploymentUnitType.Job, jobName, this.stateCalculator.calculate(job, new DefaultModuleDeploymentPropertiesProvider(job), statusList));
            }
            catch (Exception e) {
                logger.error(String.format("Exception calculating status for job %s; status will be set to %s.", new Object[]{jobName, DeploymentUnitStatus.State.unknown}), (Throwable)e);
                this.writeDeploymentUnitStatus(DeploymentUnitType.Job, jobName, new DeploymentUnitStatus(DeploymentUnitStatus.State.unknown));
            }
        }
    }

    private void writeDeploymentUnitStatus(DeploymentUnitType type, String name, DeploymentUnitStatus status) throws Exception {
        CuratorFramework client = this.zkConnection.getClient();
        logger.info("Deployment status for {} '{}': {}", new Object[]{type, name, status});
        String statusPath = Paths.build(type == DeploymentUnitType.Stream ? "deployments/streams" : "deployments/jobs", name, "status");
        Stat stat = (Stat)client.checkExists().forPath(statusPath);
        if (stat != null) {
            logger.trace("Found old status path {}; stat: {}", (Object)statusPath, (Object)stat);
            client.delete().forPath(statusPath);
        }
        ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(statusPath, ZooKeeperUtils.mapToBytes(status.toMap()));
    }

    @Override
    public void onSupervisorElected(SupervisorElectedEvent supervisorElectedEvent) throws Exception {
        this.recalculateStreamStates(supervisorElectedEvent.getStreamDeployments());
        this.recalculateJobStates(supervisorElectedEvent.getJobDeployments());
    }
}

