/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.core.JobDeploymentsPath;
import org.springframework.xd.dirt.core.ModuleDeploymentRequestsPath;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.core.StreamDeploymentsPath;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.zk.DeploymentLoader;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleRedeployer;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public class ContainerMatchingModuleRedeployer
extends ModuleRedeployer {
    protected final Logger logger = LoggerFactory.getLogger(ContainerMatchingModuleRedeployer.class);
    private final PathChildrenCache streamDeployments;
    protected final PathChildrenCache jobDeployments;

    public ContainerMatchingModuleRedeployer(ZooKeeperConnection zkConnection, ContainerRepository containerRepository, StreamFactory streamFactory, JobFactory jobFactory, PathChildrenCache streamDeployments, PathChildrenCache jobDeployments, PathChildrenCache moduleDeploymentRequests, ContainerMatcher containerMatcher, ModuleDeploymentWriter moduleDeploymentWriter, DeploymentUnitStateCalculator stateCalculator) {
        super(zkConnection, containerRepository, streamFactory, jobFactory, moduleDeploymentRequests, containerMatcher, moduleDeploymentWriter, stateCalculator);
        this.streamDeployments = streamDeployments;
        this.jobDeployments = jobDeployments;
    }

    @Override
    protected void deployModules(Container container) throws Exception {
        this.deployUnallocatedStreamModules();
        this.deployUnallocatedJobModules();
    }

    private void deployUnallocatedStreamModules() throws Exception {
        List<ModuleDeploymentRequestsPath> requestedModulesPaths = this.getAllModuleDeploymentRequests();
        CuratorFramework client = this.getClient();
        for (ChildData data : this.streamDeployments.getCurrentData()) {
            String streamName = ZooKeeperUtils.stripPathConverter.convert(data);
            try {
                Stream stream = DeploymentLoader.loadStream(client, streamName, this.streamFactory);
                if (stream == null) continue;
                List<ModuleDeploymentRequestsPath> requestedModules = ModuleDeploymentRequestsPath.getModulesForDeploymentUnit(requestedModulesPaths, streamName);
                HashSet<String> previouslyDeployed = new HashSet<String>();
                for (String deployedModule : (List)client.getChildren().forPath(Paths.build(data.getPath(), "modules"))) {
                    previouslyDeployed.add(Paths.stripPath(new StreamDeploymentsPath(Paths.build(data.getPath(), "modules", deployedModule)).getModuleInstanceAsString()));
                }
                for (ModuleDeploymentRequestsPath path : requestedModules) {
                    ModuleDescriptor moduleDescriptor = stream.getModuleDescriptor(path.getModuleLabel());
                    if (!this.shouldDeploy(moduleDescriptor, path, previouslyDeployed)) continue;
                    RuntimeModuleDeploymentProperties moduleDeploymentProperties = new RuntimeModuleDeploymentProperties();
                    moduleDeploymentProperties.putAll(ZooKeeperUtils.bytesToMap(this.moduleDeploymentRequests.getCurrentData(path.build()).getData()));
                    this.redeployModule(new ModuleRedeployer.ModuleDeployment(stream, moduleDescriptor, moduleDeploymentProperties), true);
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("Exception while evaluating module status for stream %s", streamName), (Throwable)e);
            }
        }
    }

    private void deployUnallocatedJobModules() throws Exception {
        List<ModuleDeploymentRequestsPath> requestedModulesPaths = this.getAllModuleDeploymentRequests();
        CuratorFramework client = this.getClient();
        for (ChildData data : this.jobDeployments.getCurrentData()) {
            String jobName = ZooKeeperUtils.stripPathConverter.convert(data);
            try {
                Job job = DeploymentLoader.loadJob(client, jobName, this.jobFactory);
                if (job == null) continue;
                List<ModuleDeploymentRequestsPath> requestedModules = ModuleDeploymentRequestsPath.getModulesForDeploymentUnit(requestedModulesPaths, jobName);
                HashSet<String> previouslyDeployed = new HashSet<String>();
                for (String deployedModule : (List)client.getChildren().forPath(Paths.build(data.getPath(), "modules"))) {
                    previouslyDeployed.add(Paths.stripPath(new JobDeploymentsPath(Paths.build(data.getPath(), "modules", deployedModule)).getModuleInstanceAsString()));
                }
                for (ModuleDeploymentRequestsPath path : requestedModules) {
                    ModuleDescriptor moduleDescriptor = job.getJobModuleDescriptor();
                    if (!this.shouldDeploy(moduleDescriptor, path, previouslyDeployed)) continue;
                    RuntimeModuleDeploymentProperties moduleDeploymentProperties = new RuntimeModuleDeploymentProperties();
                    moduleDeploymentProperties.putAll(ZooKeeperUtils.bytesToMap(this.moduleDeploymentRequests.getCurrentData(path.build()).getData()));
                    this.redeployModule(new ModuleRedeployer.ModuleDeployment(job, moduleDescriptor, moduleDeploymentProperties), true);
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("Exception while evaluating module status for job %s", jobName), (Throwable)e);
            }
        }
    }

    private boolean shouldDeploy(ModuleDescriptor moduleDescriptor, ModuleDeploymentRequestsPath path, Set<String> previouslyDeployed) {
        return path.getModuleSequence().equals("0") || !previouslyDeployed.contains(path.getModuleInstanceAsString());
    }
}

