/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment.zk;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.job.JobFactory;
import org.springframework.xd.dirt.server.admin.deployment.ContainerMatcher;
import org.springframework.xd.dirt.server.admin.deployment.DeploymentUnitStateCalculator;
import org.springframework.xd.dirt.server.admin.deployment.zk.ContainerMatchingModuleRedeployer;
import org.springframework.xd.dirt.server.admin.deployment.zk.DepartedContainerModuleRedeployer;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleDeploymentWriter;
import org.springframework.xd.dirt.server.admin.deployment.zk.ModuleRedeployer;
import org.springframework.xd.dirt.stream.StreamFactory;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ContainerListener
implements PathChildrenCacheListener {
    private final Logger logger = LoggerFactory.getLogger(ContainerListener.class);
    private final ZooKeeperConnection zkConnection;
    private final ContainerMatchingModuleRedeployer containerMatchingModuleRedeployer;
    private final ModuleRedeployer departedContainerModuleRedeployer;
    private final ArrivingContainerDeployer arrivingContainerDeployer = new ArrivingContainerDeployer();
    private final DepartedContainerDeployer departedContainerDeployer = new DepartedContainerDeployer();
    private final AtomicLong quietPeriod;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<ContainerArrival> latestContainer = new AtomicReference();

    public ContainerListener(ZooKeeperConnection zkConnection, ContainerRepository containerRepository, StreamFactory streamFactory, JobFactory jobFactory, PathChildrenCache streamDeployments, PathChildrenCache jobDeployments, PathChildrenCache moduleDeploymentRequests, ContainerMatcher containerMatcher, ModuleDeploymentWriter moduleDeploymentWriter, DeploymentUnitStateCalculator stateCalculator, ScheduledExecutorService executorService, AtomicLong quietPeriod) {
        this.zkConnection = zkConnection;
        this.containerMatchingModuleRedeployer = new ContainerMatchingModuleRedeployer(zkConnection, containerRepository, streamFactory, jobFactory, streamDeployments, jobDeployments, moduleDeploymentRequests, containerMatcher, moduleDeploymentWriter, stateCalculator);
        this.departedContainerModuleRedeployer = new DepartedContainerModuleRedeployer(zkConnection, containerRepository, streamFactory, jobFactory, moduleDeploymentRequests, containerMatcher, moduleDeploymentWriter, stateCalculator);
        this.quietPeriod = quietPeriod;
        this.executorService = executorService;
    }

    public void scheduleDepartedContainerDeployer() {
        this.departedContainerDeployer.scheduleOngoing();
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        ZooKeeperUtils.logCacheEvent(this.logger, event);
        switch (event.getType()) {
            case CHILD_ADDED: {
                Container container = this.getContainer(event.getData());
                this.logger.info("Container arrived: {}", (Object)container);
                this.latestContainer.set(new ContainerArrival(container, System.currentTimeMillis()));
                this.arrivingContainerDeployer.schedule();
                break;
            }
            case CHILD_UPDATED: {
                break;
            }
            case CHILD_REMOVED: {
                Container container = this.getContainer(event.getData());
                this.logger.info("Container departed: {}", (Object)container);
                this.departedContainerDeployer.scheduleImmediately();
                break;
            }
            case CONNECTION_SUSPENDED: {
                break;
            }
            case CONNECTION_RECONNECTED: {
                break;
            }
            case CONNECTION_LOST: {
                break;
            }
        }
    }

    private Container getContainer(ChildData data) {
        return new Container(Paths.stripPath(data.getPath()), ZooKeeperUtils.bytesToMap(data.getData()));
    }

    private class DepartedContainerDeployer
    implements Runnable {
        private DepartedContainerDeployer() {
        }

        public void scheduleOngoing() {
            ContainerListener.this.executorService.scheduleWithFixedDelay(this, 0L, 5L, TimeUnit.SECONDS);
        }

        public void scheduleImmediately() {
            ContainerListener.this.executorService.schedule(this, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                CuratorFramework client = ContainerListener.this.zkConnection.getClient();
                HashSet containerDeployments = new HashSet();
                try {
                    containerDeployments.addAll((Collection)client.getChildren().forPath(Paths.build("deployments/modules", "allocated")));
                    containerDeployments.removeAll((Collection)client.getChildren().forPath(Paths.build("containers")));
                }
                catch (KeeperException.NoNodeException e) {
                    // empty catch block
                }
                for (String containerName : containerDeployments) {
                    Container container = new Container(containerName, Collections.emptyMap());
                    ContainerListener.this.departedContainerModuleRedeployer.deployModules(container);
                }
            }
            catch (Exception e) {
                ContainerListener.this.logger.error("Exception while handling departed containers", (Throwable)e);
            }
        }
    }

    private class ArrivingContainerDeployer
    implements Runnable {
        private final AtomicBoolean scheduled = new AtomicBoolean(false);

        private ArrivingContainerDeployer() {
        }

        void schedule() {
            if (this.scheduled.compareAndSet(false, true)) {
                long delay = Math.max(0L, ContainerListener.this.quietPeriod.get() - (System.currentTimeMillis() - ((ContainerArrival)((ContainerListener)ContainerListener.this).latestContainer.get()).timestamp));
                ContainerListener.this.logger.info("Scheduling deployments to new container(s) in {} ms ", (Object)delay);
                ContainerListener.this.executorService.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else {
                ContainerListener.this.logger.trace("Container deployment already scheduled");
            }
        }

        @Override
        public void run() {
            this.scheduled.set(false);
            ContainerArrival containerArrival = (ContainerArrival)ContainerListener.this.latestContainer.get();
            if (containerArrival != null) {
                if (System.currentTimeMillis() >= containerArrival.timestamp + ContainerListener.this.quietPeriod.get()) {
                    try {
                        ContainerListener.this.containerMatchingModuleRedeployer.deployModules(containerArrival.container);
                        ContainerListener.this.latestContainer.compareAndSet(containerArrival, null);
                    }
                    catch (Exception e) {
                        ContainerListener.this.logger.error("Error deploying to container " + containerArrival.container, (Throwable)e);
                    }
                } else {
                    ContainerListener.this.logger.trace("Quiet period not over yet; rescheduling container deployment");
                    this.schedule();
                }
            } else {
                ContainerListener.this.logger.trace("Arrived container already processed");
            }
        }
    }

    private class ContainerArrival {
        final Container container;
        final long timestamp;

        private ContainerArrival(Container container, long timestamp) {
            this.container = container;
            this.timestamp = timestamp;
        }
    }
}

