/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.server.admin.deployment;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xd.dirt.core.Stream;
import org.springframework.xd.dirt.server.admin.deployment.ModuleDeploymentPropertiesProvider;
import org.springframework.xd.dirt.server.admin.deployment.RuntimeModuleDeploymentPropertiesProvider;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.RuntimeModuleDeploymentProperties;

public class StreamRuntimePropertiesProvider
extends RuntimeModuleDeploymentPropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(StreamRuntimePropertiesProvider.class);
    private final Stream stream;

    public StreamRuntimePropertiesProvider(Stream stream, ModuleDeploymentPropertiesProvider<ModuleDeploymentProperties> propertiesProvider) {
        super(propertiesProvider);
        this.stream = stream;
    }

    @Override
    public RuntimeModuleDeploymentProperties propertiesForDescriptor(ModuleDescriptor moduleDescriptor) {
        Object nextProperties;
        List<ModuleDescriptor> streamModules = this.stream.getModuleDescriptors();
        RuntimeModuleDeploymentProperties properties = super.propertiesForDescriptor(moduleDescriptor);
        int moduleSequence = properties.getSequence();
        int moduleIndex = moduleDescriptor.getIndex();
        if (moduleIndex > 0 || this.isNamedChannelInput(moduleDescriptor)) {
            properties.put("consumer.sequence", String.valueOf(moduleSequence));
            properties.put("consumer.count", String.valueOf(properties.getCount()));
        }
        if (moduleIndex > 0) {
            String minPartitionCount;
            ModuleDescriptor previous = streamModules.get(moduleIndex - 1);
            Object previousProperties = this.deploymentPropertiesProvider.propertiesForDescriptor(previous);
            if (this.hasPartitionKeyProperty((ModuleDeploymentProperties)previousProperties)) {
                properties.put("consumer.partitionIndex", String.valueOf(moduleSequence - 1));
            }
            if ((minPartitionCount = previousProperties.get((Object)"producer.minPartitionCount")) != null) {
                properties.put("consumer.minPartitionCount", minPartitionCount);
            }
        }
        if (moduleIndex + 1 < streamModules.size()) {
            String concurrency;
            nextProperties = this.deploymentPropertiesProvider.propertiesForDescriptor(streamModules.get(moduleIndex + 1));
            String count = nextProperties.get((Object)"count");
            if (count != null) {
                properties.put("producer.next.module.count", count);
            }
            if ((concurrency = nextProperties.get((Object)"consumer.concurrency")) != null) {
                properties.put("producer.next.module.concurrency", concurrency);
            }
        }
        if (this.hasPartitionKeyProperty((ModuleDeploymentProperties)properties)) {
            if (moduleIndex == streamModules.size() && !this.isNamedChannelOutput(moduleDescriptor)) {
                logger.warn("Module '{}' is a sink module which contains a property of '{}' used for data partitioning; this feature is only supported for modules that produce data", (Object)moduleDescriptor, (Object)"producer.partitionKeyExpression");
            }
        } else if (moduleIndex + 1 < streamModules.size()) {
            String criteria;
            nextProperties = this.deploymentPropertiesProvider.propertiesForDescriptor(streamModules.get(moduleIndex + 1));
            String directBindingKey = "producer.directBindingAllowed";
            String directBindingValue = properties.get((Object)directBindingKey);
            if (directBindingValue != null && !"false".equalsIgnoreCase(directBindingValue)) {
                logger.warn("Only 'false' is allowed as an explicit value for the {} property,  but the value was: '{}'", (Object)directBindingKey, (Object)directBindingValue);
            }
            if (!"false".equalsIgnoreCase(properties.get((Object)directBindingKey)) && properties.getCount() == 0 && nextProperties.getCount() == 0 && ((criteria = properties.getCriteria()) == null && nextProperties.getCriteria() == null || criteria != null && criteria.equals(nextProperties.getCriteria()))) {
                properties.put(directBindingKey, Boolean.toString(true));
            }
        }
        return properties;
    }

    private boolean isNamedChannelInput(ModuleDescriptor moduleDescriptor) {
        String sourceChannelName = moduleDescriptor.getSourceChannelName();
        return sourceChannelName != null && (sourceChannelName.startsWith("tap:") || sourceChannelName.startsWith("topic:") || sourceChannelName.startsWith("queue:"));
    }

    private boolean isNamedChannelOutput(ModuleDescriptor moduleDescriptor) {
        String sinkChannelName = moduleDescriptor.getSinkChannelName();
        return sinkChannelName != null && (sinkChannelName.startsWith("topic:") || sinkChannelName.startsWith("queue:"));
    }

    private boolean hasPartitionKeyProperty(ModuleDeploymentProperties properties) {
        return properties.containsKey((Object)"producer.partitionKeyExpression") || properties.containsKey((Object)"producer.partitionKeyExtractorClass");
    }
}

